/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset;

import freak.module.searchspace.PointSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class LtSFile {
    PointSet.Point[] pointData;
    int pointDim;
    int numberPoints;

    public LtSFile(File inFile) throws IOException {
        FileReader in = new FileReader(inFile);
        BufferedReader reader = new BufferedReader(in);
        this.readInData(reader);
    }

    public int getPointDimension() {
        return this.pointDim;
    }

    public int getDimension() {
        return this.numberPoints;
    }

    private void readInData(BufferedReader in) throws IOException {
        String line = in.readLine();
        int ExpectedDim = -1;
        ArrayList<PointSet.Point> points = new ArrayList<PointSet.Point>();
        while (line != null) {
            StringTokenizer strTokzer = new StringTokenizer(line, ",");
            ArrayList<Double> komponents = new ArrayList<Double>();
            while (strTokzer.hasMoreTokens()) {
                String token = strTokzer.nextToken();
                komponents.add(new Double(token));
            }
            if (komponents.size() != ExpectedDim && ExpectedDim != -1) {
                System.out.println("Unsuspected line: " + line);
            } else {
                ExpectedDim = komponents.size();
                points.add(new PointSet.Point(komponents));
            }
            line = in.readLine();
        }
        this.pointData = new PointSet.Point[points.size()];
        int i = 0;
        Iterator it = points.iterator();
        while (it.hasNext()) {
            this.pointData[i] = (PointSet.Point)it.next();
            ++i;
        }
        this.numberPoints = this.pointData.length;
        this.pointDim = ExpectedDim;
    }

    public PointSet.Point[] getPointData() {
        return this.pointData;
    }
}

