/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.searchspace.SearchSpace;
import freak.gui.JButtonFactory;
import freak.gui.ModuleList;
import freak.gui.scheduleeditor.ScheduleEditor;
import freak.gui.scheduleeditor.ScheduleEditorPanel;
import freak.gui.scheduleeditor.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelSearchSpace
extends ScheduleEditorPanel {
    private Module[] searchSpaces;
    private JButton buConfigSearchspace;
    private JLabel jLabel1;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JList listSearchspaces;
    private JTextArea taDescrSearchspace;
    private JTextField tfOptionsSearchspace;

    public PanelSearchSpace(ScheduleEditor scheduleEditor) {
        super(scheduleEditor);
        this.initComponents();
    }

    public static String getDescription() {
        return "Select Search Space";
    }

    protected void initForStartedSchedule() {
        this.listSearchspaces.setEnabled(false);
        this.buConfigSearchspace.setVisible(false);
    }

    public String getHelpURL() {
        return "node4.html#SECTION00441000000000000000";
    }

    public boolean mayAdvance() {
        return this.schedule.getPhenotypeSearchSpace() != null;
    }

    public void enter() {
        super.enter();
        this.searchSpaces = this.moduleCollector.getSearchSpaces();
        ((ModuleList)this.listSearchspaces).setModules(this.searchSpaces, this.schedule.getPhenotypeSearchSpace());
    }

    private void parse() {
        SearchSpace m = this.schedule.getPhenotypeSearchSpace();
        Util.displayText(this.taDescrSearchspace, m.getDescription());
        if (m instanceof Configurable) {
            Util.displayText(this.tfOptionsSearchspace, ((Configurable)((Object)m)).getConfiguration().getDescription());
        } else {
            Util.displayText(this.tfOptionsSearchspace, "<not configurable>");
        }
        this.buConfigSearchspace.setEnabled(m instanceof Configurable);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.buConfigSearchspace = JButtonFactory.newButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.listSearchspaces = new ModuleList();
        this.jLabel2 = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.taDescrSearchspace = new JTextArea();
        this.jLabel18 = new JLabel();
        this.tfOptionsSearchspace = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Select Search Space"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.buConfigSearchspace.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buConfigSearchspace.setMnemonic('o');
        this.buConfigSearchspace.setText("Configure...");
        this.buConfigSearchspace.setEnabled(false);
        this.buConfigSearchspace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelSearchSpace.this.buConfigSearchspaceActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.buConfigSearchspace, gridBagConstraints);
        this.jLabel1.setText("Options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane5.setMinimumSize(new Dimension(220, 0));
        this.jScrollPane5.setPreferredSize(new Dimension(220, 0));
        this.listSearchspaces.setSelectionMode(0);
        this.listSearchspaces.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelSearchSpace.this.listSearchspacesValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.listSearchspaces);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jScrollPane5, gridBagConstraints);
        this.jLabel2.setText("Search Spaces:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.taDescrSearchspace.setEditable(false);
        this.taDescrSearchspace.setLineWrap(true);
        this.taDescrSearchspace.setText("<no search space selected>");
        this.taDescrSearchspace.setWrapStyleWord(true);
        this.jScrollPane6.setViewportView(this.taDescrSearchspace);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.jScrollPane6, gridBagConstraints);
        this.jLabel18.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel18, gridBagConstraints);
        this.tfOptionsSearchspace.setEditable(false);
        this.tfOptionsSearchspace.setText("<no search space selected>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanel1.add((Component)this.tfOptionsSearchspace, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void buConfigSearchspaceActionPerformed(ActionEvent evt) {
        String s = Util.configureModule(this.scheduleEditor, this.schedule.getPhenotypeSearchSpace(), this.schedule);
        if (s != null) {
            Util.displayText(this.tfOptionsSearchspace, s);
        }
        this.scheduleDependencyChecker.processNewModuleConfiguration(this.schedule.getGenotypeSearchSpace());
        this.scheduleEditor.updateComponents();
    }

    private void listSearchspacesValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        SearchSpace oldObj = this.schedule.getPhenotypeSearchSpace();
        SearchSpace newObj = (SearchSpace)this.listSearchspaces.getSelectedValue();
        if (newObj != oldObj) {
            if (oldObj != null) {
                this.eventController.replaceGlobalEventSource(oldObj, newObj);
                this.eventController.removeModule(oldObj);
            }
            this.schedule.setPhenotypeSearchSpace(newObj);
            this.scheduleDependencyChecker.processNewSearchSpace();
            newObj.createEvents();
            this.scheduleEditor.updateComponents();
        }
        this.parse();
    }
}

