/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.graph.FreakGraphModel;
import freak.core.modulesupport.ClassCollector;
import freak.core.modulesupport.ModuleInfo;
import freak.core.modulesupport.OperatorGraphCollector;
import freak.gui.JButtonFactory;
import freak.gui.graph.EditorDialog;
import freak.gui.graph.OperatorGraphFile;
import freak.gui.runframe.SingleExtensionFileFilter;
import freak.gui.scheduleeditor.ScheduleEditor;
import freak.gui.scheduleeditor.ScheduleEditorPanel;
import freak.gui.scheduleeditor.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.jar.JarFile;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.jgraph.JGraph;

public class PanelGraph
extends ScheduleEditorPanel {
    private FreakGraphModel graphModel;
    private JGraph graphPreview;
    protected OperatorGraphCollector graphCollector;
    private JButton buEditGraph;
    private JButton buOpen;
    private JComboBox comboPredefinedGraphs;
    private JPanel jPanel1;
    private JPanel jPanel15;
    private JLabel labelPredefGraphs;
    private JPanel panelGraph;
    private JScrollPane scrollpaneGraph;

    public PanelGraph(ScheduleEditor scheduleEditor) {
        super(scheduleEditor);
        this.graphModel = this.schedule.getFreakGraphModel();
        this.graphCollector = new OperatorGraphCollector(this.schedule);
        this.initComponents();
        this.initPredefinedGraphs();
    }

    public static String getDescription() {
        return "Create Algorithm-Graph";
    }

    public String getHelpURL() {
        return "node4.html#SECTION00444000000000000000";
    }

    private void initPredefinedGraphs() {
        ModuleInfo[] mi = this.graphCollector.getPredefinedGraphs(null);
        if (mi.length == 0) {
            this.comboPredefinedGraphs.addItem("No predefined graphs found");
            this.comboPredefinedGraphs.setSelectedIndex(0);
            this.comboPredefinedGraphs.setEnabled(false);
            this.labelPredefGraphs.setEnabled(false);
            return;
        }
        this.comboPredefinedGraphs.setEnabled(true);
        this.labelPredefGraphs.setEnabled(true);
        int i = 0;
        while (i < mi.length) {
            this.comboPredefinedGraphs.addItem(mi[i]);
            ++i;
        }
        this.comboPredefinedGraphs.setSelectedIndex(-1);
        this.comboPredefinedGraphs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelGraph.this.eventPredefinedGraphSelected(evt);
            }
        });
        if ((this.schedule.getFreakGraphModel() == null || this.schedule.getOperatorGraph().isEmpty()) && mi.length > 0) {
            this.comboPredefinedGraphs.setSelectedIndex(0);
        }
    }

    private void eventPredefinedGraphSelected(ActionEvent evt) {
        Object o = this.comboPredefinedGraphs.getSelectedItem();
        if (o instanceof ModuleInfo) {
            ModuleInfo mi = (ModuleInfo)o;
            this.loadPredefinedGraph(mi);
        } else {
            this.loadPredefinedGraph(null);
        }
    }

    public boolean mayAdvance() {
        return this.graphModel != null;
    }

    public boolean advanceVeto() {
        return !this.scheduleDependencyChecker.isGraphCorrect();
    }

    public void enter() {
        super.enter();
        this.graphPreview = new JGraph();
        this.graphPreview.setEnabled(false);
        this.scrollpaneGraph.setViewportView(this.graphPreview);
        this.parse();
    }

    private void parse() {
        this.graphModel = this.schedule.getFreakGraphModel();
        if (this.graphModel == null) {
            this.graphModel = new FreakGraphModel(this.schedule);
            this.graphModel.getOperatorGraph().createEvents();
            this.schedule.setGraphModel(this.graphModel);
            this.scheduleDependencyChecker.processNewGraph();
        }
        this.graphPreview.setModel(this.graphModel);
    }

    private void loadPredefinedGraph(ModuleInfo mi) {
        if (mi != null) {
            this.scheduleDependencyChecker.removeGraph();
            try {
                OperatorGraphFile ogFile;
                String startedFrom = ClassCollector.getStartedFrom();
                if (mi.getClassName().startsWith("freak") && startedFrom.toLowerCase().endsWith(".jar")) {
                    JarFile jf = new JarFile(startedFrom);
                    ogFile = OperatorGraphFile.read(jf.getInputStream(jf.getJarEntry(mi.getClassName())));
                } else {
                    ogFile = OperatorGraphFile.read(new FileInputStream(new File(mi.getClassName())));
                }
                FreakGraphModel model = ogFile.generateGraph(this.schedule);
                model.getOperatorGraph().setName(mi.getName());
                this.schedule.setGraphModel(model);
                this.scheduleDependencyChecker.processNewGraph();
                this.scheduleEditor.updateComponents();
                if (this.graphPreview != null) {
                    this.graphPreview.setModel(model);
                }
            }
            catch (Exception exc) {
                System.out.println("Error loading graph " + mi.getClassName());
            }
        }
    }

    private void initComponents() {
        this.panelGraph = new JPanel();
        this.scrollpaneGraph = new JScrollPane();
        this.jPanel15 = new JPanel();
        this.labelPredefGraphs = new JLabel();
        this.comboPredefinedGraphs = new JComboBox();
        this.jPanel1 = new JPanel();
        this.buEditGraph = JButtonFactory.newButton();
        this.buOpen = JButtonFactory.newButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Create Algorithm Graph"));
        this.panelGraph.setLayout(new GridBagLayout());
        this.panelGraph.setBorder(new TitledBorder("Graph Preview"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.panelGraph.add((Component)this.scrollpaneGraph, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.panelGraph, gridBagConstraints);
        this.jPanel15.setLayout(new GridBagLayout());
        this.labelPredefGraphs.setText("Predefined Graphs:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel15.add((Component)this.labelPredefGraphs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.jPanel15.add((Component)this.comboPredefinedGraphs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel15, gridBagConstraints);
        this.buEditGraph.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit16.gif")));
        this.buEditGraph.setMnemonic('e');
        this.buEditGraph.setText("Edit Graph...");
        this.buEditGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelGraph.this.buEditGraphActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buEditGraph);
        this.buOpen.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        this.buOpen.setMnemonic('o');
        this.buOpen.setText("Open...");
        this.buOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelGraph.this.buOpenActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buOpen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void buOpenActionPerformed(ActionEvent evt) {
        JFileChooser c = new JFileChooser();
        c.setFileFilter(new SingleExtensionFileFilter(".fop", "Freak Operator Graph"));
        int accepted = c.showOpenDialog(this);
        if (accepted != 0) {
            return;
        }
        File f = c.getSelectedFile();
        FreakGraphModel newGraph = Util.loadOperatorGraph(f.getAbsolutePath(), this.schedule);
        if (newGraph != null) {
            this.graphModel.getOperatorGraph().removeFromEventController();
            this.schedule.setGraphModel(newGraph);
            this.scheduleDependencyChecker.processNewGraph();
            this.parse();
            this.scheduleEditor.updateComponents();
        } else {
            JOptionPane.showMessageDialog(this, "Error loading operatorgraph\n" + f.getAbsolutePath());
        }
    }

    private void buEditGraphActionPerformed(ActionEvent evt) {
        EditorDialog gred = new EditorDialog((Dialog)this.scheduleEditor, this.schedule);
        gred.setLocationRelativeTo(null);
        gred.setVisible(true);
        this.comboPredefinedGraphs.setSelectedIndex(-1);
        this.scheduleDependencyChecker.processNewGraph();
        this.parse();
        this.scheduleEditor.updateComponents();
        gred.dispose();
    }
}

