/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;

public class CurrentAges
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public CurrentAges(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public String getName() {
        return "Current Ages";
    }

    public String getDescription() {
        return "Computes the ages of the observed individuals.";
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        double[] ages = new double[individuals.length];
        int generation = this.getSchedule().getCurrentGeneration();
        int i = 0;
        while (i < individuals.length) {
            ages[i] = generation - individuals[i].getDateOfBirth();
            ++i;
        }
        this.updateViews(ages);
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

