/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.cycle.tsp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;

public class TSPFile
implements Serializable {
    private String name = "n/a";
    private String comment = "none";
    private int edge_weight_type;
    private int dimension;
    private double[][] points;
    private double[] borderRectangle = new double[4];

    public int getDimension() {
        return this.dimension;
    }

    public int getEdgeWeightType() {
        return this.edge_weight_type;
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public double[][] getPoints() {
        return this.points;
    }

    public double[] getBorderRectangle() {
        return this.borderRectangle;
    }

    private void readPoints(BufferedReader reader) throws IOException {
        this.borderRectangle[0] = Double.POSITIVE_INFINITY;
        this.borderRectangle[1] = Double.POSITIVE_INFINITY;
        this.borderRectangle[2] = Double.NEGATIVE_INFINITY;
        this.borderRectangle[3] = Double.NEGATIVE_INFINITY;
        String line = reader.readLine().trim();
        int i = 0;
        while (line.length() > 4) {
            String[] coords = (line = line.trim()).split("\\s++");
            if (coords.length != 3) {
                System.out.println("Unexpected line: " + line);
            }
            this.points[i][0] = Double.parseDouble(coords[1]);
            this.points[i][1] = Double.parseDouble(coords[2]);
            if (this.points[i][0] < this.borderRectangle[0]) {
                this.borderRectangle[0] = this.points[i][0];
            }
            if (this.points[i][1] < this.borderRectangle[1]) {
                this.borderRectangle[1] = this.points[i][1];
            }
            if (this.points[i][0] > this.borderRectangle[2]) {
                this.borderRectangle[2] = this.points[i][0];
            }
            if (this.points[i][1] > this.borderRectangle[3]) {
                this.borderRectangle[3] = this.points[i][1];
            }
            if ((line = reader.readLine()) == null) {
                return;
            }
            line = line.trim();
            ++i;
        }
    }

    public TSPFile(File file) throws Exception {
        FileReader in = new FileReader(file);
        BufferedReader reader = new BufferedReader(in);
        try {
            String line;
            while (!(line = reader.readLine().trim()).equalsIgnoreCase("EOF")) {
                if (line.equalsIgnoreCase("NODE_COORD_SECTION")) {
                    if (this.dimension > 0) {
                        this.points = new double[this.dimension][2];
                        this.readPoints(reader);
                        return;
                    }
                    System.out.println(String.valueOf(file.getName()) + ": Dimension not specified.");
                    throw new Exception("no dimension");
                }
                String[] params = line.split(":");
                if (params.length != 2) {
                    System.out.println("Unexpected line: " + line);
                    throw new Exception("Unexpected line");
                }
                params[0] = params[0].trim();
                params[1] = params[1].trim();
                if (params[0].equalsIgnoreCase("NAME")) {
                    this.name = params[1].toUpperCase();
                }
                if (params[0].equalsIgnoreCase("TYPE") && !params[1].equalsIgnoreCase("TSP")) {
                    System.out.println("No TSP file: " + file.getName());
                    throw new Exception("only TSP Files");
                }
                if (params[0].equalsIgnoreCase("COMMENT")) {
                    this.comment = params[1];
                }
                if (params[0].equalsIgnoreCase("EDGE_WEIGHT_TYPE")) {
                    if (params[1].equalsIgnoreCase("EUC_2D")) {
                        this.edge_weight_type = 1;
                    } else if (params[1].equalsIgnoreCase("CEIL_2D")) {
                        this.edge_weight_type = 2;
                    } else if (params[1].equalsIgnoreCase("GEO")) {
                        this.edge_weight_type = 3;
                    } else if (params[1].equalsIgnoreCase("ATT")) {
                        this.edge_weight_type = 4;
                    } else {
                        if (params[1].equalsIgnoreCase("EXPLICIT")) {
                            System.out.println(String.valueOf(file.getName()) + ": edge weight type EXPLICIT not supported!");
                            throw new Exception();
                        }
                        System.out.println("Unknown edge weight type: " + params[1]);
                        this.edge_weight_type = 0;
                    }
                }
                if (!params[0].equalsIgnoreCase("DIMENSION")) continue;
                this.dimension = new Integer(params[1]);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + file.getName() + " not found.");
        }
    }
}

