/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport.inspector;

import freak.core.modulesupport.inspector.StandardInspectorFactory;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class CustomizableInspectorTable
extends JTable {
    public CustomizableInspectorTable(TableModel dm) {
        super(dm);
    }

    public CustomizableInspectorTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public CustomizableInspectorTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public CustomizableInspectorTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public CustomizableInspectorTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public CustomizableInspectorTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public void customize(Class cls, TableCellRenderer renderer, TableCellEditor editor) {
        this.setDefaultRenderer(cls, renderer);
        this.setDefaultEditor(cls, editor);
        this.setRowHeight(22);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        Object value = this.getValueAt(row, column);
        if (value == null) {
            return this.getDefaultRenderer(Object.class);
        }
        return this.getDefaultRenderer(value.getClass());
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Object value = this.getValueAt(row, column);
        if (value == null) {
            return this.getDefaultEditor(Object.class);
        }
        return this.getDefaultEditor(value.getClass());
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component editorComponent = editor.getTableCellEditorComponent(this, this.getValueAt(row, column), true, row, column);
        if (editorComponent instanceof JTextComponent) {
            editorComponent.addFocusListener(new EditorComponentFocusListener());
        }
        return super.prepareEditor(editor, row, column);
    }

    public void updateTable() {
        StandardInspectorFactory.StandardInspectorTableModel model = (StandardInspectorFactory.StandardInspectorTableModel)this.getModel();
        model.updateAllFields();
    }

    class EditorComponentFocusListener
    implements FocusListener {
        EditorComponentFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            int row = CustomizableInspectorTable.this.getEditingRow();
            int col = CustomizableInspectorTable.this.getEditingColumn();
            if (row != -1 && col != -1) {
                TableCellEditor editor = CustomizableInspectorTable.this.getCellEditor(row, col);
                editor.stopCellEditing();
            }
            ((Component)e.getSource()).removeFocusListener(this);
        }
    }
}

