/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.GraphModel;

public class ParentMap
implements Serializable {
    protected ArrayList entries = new ArrayList();
    protected Set changedNodes = new HashSet();
    protected Map childCount = new Hashtable();

    public static ParentMap create(GraphModel graphModel, Object[] objectArray, boolean bl, boolean bl2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < objectArray.length) {
            hashSet.add(objectArray[n]);
            ++n;
        }
        ParentMap parentMap = new ParentMap();
        int n2 = objectArray.length - 1;
        while (n2 >= 0) {
            Object object = graphModel.getParent(objectArray[n2]);
            if (object != null && (!bl2 || !bl && hashSet.contains(object))) {
                parentMap.addEntry(objectArray[n2], bl ? null : object);
            }
            if (bl) {
                while (hashSet.contains(object)) {
                    object = graphModel.getParent(object);
                }
                int n3 = 0;
                while (n3 < graphModel.getChildCount(objectArray[n2])) {
                    Object object2 = graphModel.getChild(objectArray[n2], n3);
                    if (!hashSet.contains(object2)) {
                        parentMap.addEntry(object2, object);
                    }
                    ++n3;
                }
            }
            --n2;
        }
        return parentMap;
    }

    public void addEntry(Object object, Object object2) {
        if (object != null) {
            this.entries.add(new Entry(object, object2));
            this.changedNodes.add(object);
            if (object2 != null) {
                this.changedNodes.add(object2);
            }
        }
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator entries() {
        return this.entries.iterator();
    }

    public Set getChangedNodes() {
        return this.changedNodes;
    }

    public ParentMap clone(Map map) {
        ParentMap parentMap = new ParentMap();
        Iterator iterator = this.entries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            Object object = map.get(entry.getChild());
            Object object2 = map.get(entry.getParent());
            if (object == null) {
                object = entry.getChild();
            }
            if (object2 == null) {
                object2 = entry.getParent();
            }
            if (object == null || object2 == null) continue;
            parentMap.addEntry(object, object2);
        }
        return parentMap;
    }

    public String toString() {
        String string = super.toString() + "\n";
        Iterator iterator = this.entries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            string = string + " child=" + entry.getChild() + " parent=" + entry.getParent() + "\n";
        }
        return string;
    }

    public class Entry
    implements Serializable {
        protected Object child;
        protected Object parent;

        public Entry(Object object, Object object2) {
            this.child = object;
            this.parent = object2;
        }

        public Object getChild() {
            return this.child;
        }

        public Object getParent() {
            return this.parent;
        }
    }
}

