/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.searchspace.HasDimension;
import freak.core.stoppingcriterion.AbstractStoppingCriterion;

public class NoImprovementBestFitness
extends AbstractStoppingCriterion
implements Configurable,
GenerationEventListener {
    private int generations = 1000;
    private int noImprovement = -1;
    private double lastFitness;

    public NoImprovementBestFitness(Schedule schedule) {
        super(schedule);
        if (schedule.getGenotypeSearchSpace() instanceof HasDimension) {
            this.generations = 2 * ((HasDimension)((Object)schedule.getGenotypeSearchSpace())).getDimension();
        }
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public String getName() {
        return "No Improvement of Best Fitness";
    }

    public String getDescription() {
        return "This stopping-criterium stops when the best fitness remains unchanged for a specified amount of generations";
    }

    public void setPropertyGenerations(Integer generations) {
        if (generations > 0) {
            this.generations = generations;
        }
    }

    public Integer getPropertyGenerations() {
        return new Integer(this.generations);
    }

    public String getShortDescriptionForGenerations() {
        return "Amount of generations";
    }

    public String getLongDescriptionForGenerations() {
        return "When the best fitness remains unchanged for this amount of generations a run stops.";
    }

    public void generation(GenerationEvent evt) {
        IndividualList population = this.getSchedule().getPopulationManager().getPopulation();
        Individual ind = population.getIndividualWithRank(1);
        double fitness = ((SingleObjectiveFitnessFunction)this.getSchedule().getRealFitnessFunction()).evaluate(ind, population);
        if (fitness != this.lastFitness) {
            this.lastFitness = fitness;
            this.noImprovement = 0;
        } else {
            ++this.noImprovement;
            if (this.noImprovement >= this.generations) {
                this.stopRun();
            }
        }
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, GenerationEvent.class, this.schedule);
    }
}

