/*
 * Decompiled with CFR 0.152.
 */
package freak.core.graph;

import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.event.IndividualListEventSource;
import freak.core.graph.AbstractFork;
import freak.core.graph.GraphException;
import freak.core.graph.GraphSyntaxException;
import freak.core.graph.OperatorGraph;
import freak.core.population.IndividualList;
import java.util.HashSet;
import java.util.Iterator;

public class Start
extends AbstractFork
implements IndividualListEventSource {
    private HashSet individualListEventListeners = new HashSet();

    public Start(OperatorGraph graph) {
        super(graph);
        super.addOutPort(0);
    }

    protected void putPopulation(IndividualList population) {
        this.getInPort(0).put(population);
        if (this.individualListEventListeners.size() > 0) {
            IndividualListEvent evt = new IndividualListEvent(this, population);
            Iterator iter = this.individualListEventListeners.iterator();
            while (iter.hasNext()) {
                ((IndividualListEventListener)iter.next()).individualList(evt);
            }
        }
    }

    public void checkSyntax() throws GraphSyntaxException {
        int i = 0;
        while (i < this.getNumberOfOutPorts()) {
            this.getOutPort(i).checkSyntax();
            ++i;
        }
    }

    public String getName() {
        return "Start";
    }

    public String getDescription() {
        return "The start operator where individuals are put into the graph.";
    }

    public void addIndividualListEventListener(IndividualListEventListener l) {
        this.individualListEventListeners.add(l);
    }

    public void removeIndividualListEventListener(IndividualListEventListener l) {
        this.individualListEventListeners.remove(l);
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        return input;
    }
}

