/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection;

import freak.core.control.Schedule;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.GraphException;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class SteadyStateSelection
extends Selection
implements CompatibleWithDifferentSearchSpaces {
    public SteadyStateSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This operator works on single objective fitness functions only.");
        }
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        Vector<Integer> v;
        SingleObjectiveFitnessFunction ff = (SingleObjectiveFitnessFunction)this.getOperatorGraph().getSchedule().getFitnessFunction();
        double worst = ff.evaluate(input[0].getIndividualWithRank(input[0].size()), input[0]);
        Individual[] list = input[0].toArray();
        HashMap map = new HashMap();
        int i = 0;
        while (i < list.length) {
            if (ff.evaluate(list[i], input[0]) == worst) {
                Genotype g = list[i].getGenotype();
                Object o = map.get(g);
                if (o == null) {
                    v = new Vector<Integer>();
                    v.add(new Integer(i));
                    map.put(g, v);
                } else {
                    v = (Vector)o;
                    v.add(new Integer(i));
                }
            }
            ++i;
        }
        Iterator genotypes = map.values().iterator();
        int max = -1;
        Vector maxVector = null;
        while (genotypes.hasNext()) {
            v = (Vector<Integer>)genotypes.next();
            int size = v.size();
            if (size <= max) continue;
            max = size;
            maxVector = v;
        }
        int random = this.getOperatorGraph().getSchedule().getRandomElement().choose(0, max - 1);
        int remove = (Integer)maxVector.elementAt(random);
        Population pop = new Population(this.getOperatorGraph().getSchedule());
        int i2 = 0;
        while (i2 < remove) {
            pop.addIndividual(list[i2]);
            ++i2;
        }
        i2 = remove + 1;
        while (i2 < list.length) {
            pop.addIndividual(list[i2]);
            ++i2;
        }
        IndividualList[] result = new IndividualList[]{pop};
        return result;
    }

    public String getDescription() {
        return "Removes one individual with the worst fitness from the population. If multiple individuals have a worst fitness value, an individual among them is removed whose genotype has the largest number of clones within the individuals.";
    }

    public String getName() {
        return "Steady State Selection";
    }
}

