/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.runframe;

import freak.core.control.ScheduleStatusData;
import freak.core.view.swingsupport.FreakSpinnerModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.gui.JButtonFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class InfoPanel
extends JPanel {
    private FreakSpinnerModel batchSpinnerModel;
    private FreakSpinnerModel runSpinnerModel;
    private FreakSpinnerModel generationSpinnerModel;
    JLabel jLabelSpeedLimit;
    JButton jButtonStartStop;
    JCheckBox jCheckBoxSpeedLimit;
    JSpinner jSpinnerGeneration;
    JTextField jTextFieldSpeedLimit;
    JLabel jLabelGeneration;
    JLabel jLabelBatch;
    JSpinner jSpinnerBatch;
    JSpinner jSpinnerRun;
    JLabel jLabelRun;

    public InfoPanel() {
        this.initComponents();
        this.initSpinners();
        this.jLabelRun.setLabelFor(this.jSpinnerRun);
        this.jLabelGeneration.setLabelFor(this.jSpinnerGeneration);
        this.jLabelSpeedLimit.setLabelFor(this.jTextFieldSpeedLimit);
        this.jLabelSpeedLimit.setVisible(false);
        this.jCheckBoxSpeedLimit.setVisible(false);
        this.jSpinnerGeneration.setVisible(false);
        this.jTextFieldSpeedLimit.setVisible(false);
        this.jLabelGeneration.setVisible(false);
        this.jLabelBatch.setVisible(false);
        this.jSpinnerBatch.setVisible(false);
        this.jSpinnerRun.setVisible(false);
        this.jLabelRun.setVisible(false);
    }

    private void initSpinners() {
        this.batchSpinnerModel = new FreakSpinnerModel();
        this.runSpinnerModel = new FreakSpinnerModel();
        this.generationSpinnerModel = new FreakSpinnerModel();
        this.batchSpinnerModel.setView(this.jSpinnerBatch);
        this.runSpinnerModel.setView(this.jSpinnerRun);
        this.generationSpinnerModel.setView(this.jSpinnerGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayUpdate(ScheduleStatusData data) {
        FreakSpinnerModel freakSpinnerModel = this.generationSpinnerModel;
        synchronized (freakSpinnerModel) {
            this.generationSpinnerModel.setMaximum(data.lastReplayPointInCurrentRun.generation);
            this.generationSpinnerModel.setMinimum(data.currentTimeIndex.run == 0 ? 0 : 1);
            this.generationSpinnerModel.setValue(data.currentTimeIndex.generation);
        }
        UpdateManager.markDirty(this.generationSpinnerModel);
        freakSpinnerModel = this.runSpinnerModel;
        synchronized (freakSpinnerModel) {
            this.runSpinnerModel.setMaximum(data.lastPointInCurrentBatch.run);
            this.runSpinnerModel.setMinimum(data.currentTimeIndex.batch == 0 ? 0 : 1);
            this.runSpinnerModel.setValue(data.currentTimeIndex.run);
        }
        UpdateManager.markDirty(this.runSpinnerModel);
        freakSpinnerModel = this.batchSpinnerModel;
        synchronized (freakSpinnerModel) {
            this.batchSpinnerModel.setMaximum(data.lastReplayPoint.batch);
            this.batchSpinnerModel.setValue(data.currentTimeIndex.batch);
        }
        UpdateManager.markDirty(this.batchSpinnerModel);
    }

    private void initComponents() {
        this.jLabelRun = new JLabel();
        this.jButtonStartStop = JButtonFactory.newButton();
        this.jLabelGeneration = new JLabel();
        this.jTextFieldSpeedLimit = new JTextField();
        this.jLabelSpeedLimit = new JLabel();
        this.jSpinnerRun = new JSpinner();
        this.jSpinnerGeneration = new JSpinner();
        this.jCheckBoxSpeedLimit = new JCheckBox();
        this.jLabelBatch = new JLabel();
        this.jSpinnerBatch = new JSpinner();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.setMinimumSize(new Dimension(150, 300));
        this.setPreferredSize(new Dimension(170, 400));
        this.jLabelRun.setText("Run:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelRun, gridBagConstraints);
        this.jButtonStartStop.setText("Start");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonStartStop, gridBagConstraints);
        this.jLabelGeneration.setText("Generation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelGeneration, gridBagConstraints);
        this.jTextFieldSpeedLimit.setHorizontalAlignment(11);
        this.jTextFieldSpeedLimit.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jTextFieldSpeedLimit, gridBagConstraints);
        this.jLabelSpeedLimit.setText("Speed Limit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelSpeedLimit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jSpinnerRun, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jSpinnerGeneration, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jCheckBoxSpeedLimit, gridBagConstraints);
        this.jLabelBatch.setText("Batch:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelBatch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jSpinnerBatch, gridBagConstraints);
    }
}

