/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class VertexView
extends AbstractCellView {
    public static VertexRenderer renderer = new VertexRenderer();
    protected Rectangle bounds;
    protected Rectangle groupBounds = DefaultGraphCell.defaultBounds;

    public VertexView(Object object, JGraph jGraph, CellMapper cellMapper) {
        super(object, jGraph, cellMapper);
    }

    public void update() {
        super.update();
        this.bounds = GraphConstants.getBounds(this.allAttributes);
        this.groupBounds = null;
    }

    public void childUpdated() {
        super.childUpdated();
        this.groupBounds = null;
    }

    public Rectangle getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return this.bounds;
    }

    public Rectangle getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    protected void updateGroupBounds() {
        CellView[] cellViewArray = this.getChildViews();
        LinkedList<CellView> linkedList = new LinkedList<CellView>();
        int n = 0;
        while (n < cellViewArray.length) {
            if (this.includeInGroupBounds(cellViewArray[n])) {
                linkedList.add(cellViewArray[n]);
            }
            ++n;
        }
        cellViewArray = new CellView[linkedList.size()];
        linkedList.toArray(cellViewArray);
        this.groupBounds = AbstractCellView.getBounds(cellViewArray);
    }

    private boolean includeInGroupBounds(CellView cellView) {
        if (cellView instanceof EdgeView) {
            GraphModel graphModel = this.graph.getModel();
            EdgeView edgeView = (EdgeView)cellView;
            if (edgeView.getCell() instanceof DefaultMutableTreeNode) {
                TreeNode treeNode;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)edgeView.getCell();
                if (graphModel.getSource(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)graphModel.getSource(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
                if (graphModel.getTarget(defaultMutableTreeNode) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)graphModel.getTarget(defaultMutableTreeNode)).getParent()).isNodeDescendant(defaultMutableTreeNode)) {
                    return false;
                }
            }
        }
        return true;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        if (GraphConstants.isSizeable(this.getAllAttributes()) && graphContext.getGraph().isSizeable()) {
            return new SizeHandle(this, graphContext);
        }
        return null;
    }

    public Point getCenterPoint() {
        Rectangle rectangle = this.getBounds();
        return new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
    }

    public Point getPerimeterPoint(Point point, Point point2) {
        return renderer.getPerimeterPoint(this, point, point2);
    }

    public boolean isConstrainedSizeEvent(MouseEvent mouseEvent) {
        GraphUI graphUI = this.graph.getUI();
        if (graphUI instanceof BasicGraphUI) {
            return ((BasicGraphUI)graphUI).isConstrainedMoveEvent(mouseEvent);
        }
        return false;
    }

    public class SizeHandle
    implements CellHandle,
    Serializable {
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient JGraph graph;
        protected transient VertexView vertex;
        protected transient CellView[] portViews;
        protected transient Rectangle cachedBounds;
        protected transient GraphContext context;
        protected transient Rectangle initialBounds;
        protected transient CellView[] contextViews;
        protected transient int index = -1;
        protected transient Rectangle[] r = new Rectangle[8];
        protected boolean firstOverlayInvocation = true;
        public transient int[] cursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5};

        public SizeHandle(VertexView vertexView2, GraphContext graphContext) {
            this.graph = graphContext.getGraph();
            this.vertex = vertexView2;
            this.portViews = graphContext.createTemporaryPortViews();
            this.initialBounds = new Rectangle(this.vertex.getBounds());
            this.context = graphContext;
            int n = 0;
            while (n < this.r.length) {
                this.r[n] = new Rectangle();
                ++n;
            }
            this.invalidate();
        }

        public void paint(Graphics graphics) {
            this.invalidate();
            graphics.setColor(this.graph.getHandleColor());
            int n = 0;
            while (n < this.r.length) {
                graphics.fill3DRect(this.r[n].x, this.r[n].y, this.r[n].width, this.r[n].height, true);
                ++n;
            }
        }

        protected void initOffscreen() {
            try {
                Rectangle rectangle = this.graph.getBounds();
                this.offscreen = new BufferedImage(rectangle.width, rectangle.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                this.offgraphics.setColor(this.graph.getBackground());
                this.offgraphics.fillRect(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                this.graph.getUI().paint(this.offgraphics, this.graph);
            }
            catch (Error error) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        public void overlay(Graphics graphics) {
            if (!this.firstOverlayInvocation) {
                if (this.cachedBounds != null) {
                    graphics.setColor(Color.black);
                    Rectangle rectangle = this.graph.toScreen(new Rectangle(this.cachedBounds));
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 2, rectangle.height - 2);
                } else if (!this.initialBounds.equals(this.vertex.getBounds())) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.scale(this.graph.getScale(), this.graph.getScale());
                    this.graph.getUI().paintCell(graphics, this.vertex, this.vertex.getBounds(), true);
                    if (this.contextViews != null) {
                        int n = 0;
                        while (n < this.contextViews.length) {
                            this.graph.getUI().paintCell(graphics, this.contextViews[n], this.contextViews[n].getBounds(), true);
                            ++n;
                        }
                    }
                    graphics2D.setTransform(affineTransform);
                    if (this.portViews != null && this.graph.isPortsVisible()) {
                        this.graph.getUI().paintPorts(graphics, this.portViews);
                    }
                }
            }
            this.firstOverlayInvocation = false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.vertex != null) {
                int n = 0;
                while (n < this.r.length) {
                    if (this.r[n].contains(mouseEvent.getPoint())) {
                        this.graph.setCursor(new Cursor(this.cursors[n]));
                        mouseEvent.consume();
                        return;
                    }
                    ++n;
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.graph.isSizeable()) {
                return;
            }
            int n = 0;
            while (n < this.r.length) {
                if (this.r[n].contains(mouseEvent.getPoint())) {
                    HashSet<Object> hashSet = new HashSet<Object>();
                    hashSet.add(this.vertex.getCell());
                    this.contextViews = this.context.createTemporaryContextViews(hashSet);
                    CellView[] cellViewArray = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                    if (cellViewArray.length >= BasicGraphUI.MAXHANDLES) {
                        this.cachedBounds = new Rectangle(this.initialBounds);
                    }
                    mouseEvent.consume();
                    this.index = n;
                    return;
                }
                ++n;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            Object object;
            Graphics graphics;
            if (this.firstDrag && this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            Rectangle rectangle = null;
            Graphics graphics2 = graphics = this.offgraphics != null ? this.offgraphics : this.graph.getGraphics();
            if (this.index == -1) {
                return;
            }
            Rectangle rectangle2 = this.computeBounds(mouseEvent);
            graphics.setColor(this.graph.getForeground());
            graphics.setXORMode(this.graph.getBackground().darker());
            this.overlay(graphics);
            if (this.offgraphics != null) {
                rectangle = this.graph.toScreen(new Rectangle(this.vertex.getBounds()));
                object = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (object != null) {
                    rectangle.add((Rectangle)object);
                }
            }
            if (this.cachedBounds != null) {
                this.cachedBounds = rectangle2;
            } else {
                object = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                n = 0;
                while (n < ((CellView[])object).length) {
                    CellView cellView = this.graph.getGraphLayoutCache().getMapping(object[n].getCell(), false);
                    Map map = GraphConstants.cloneMap(cellView.getAllAttributes());
                    object[n].setAttributes(map);
                    object[n].refresh(false);
                    ++n;
                }
                this.vertex.setBounds(rectangle2);
                if (this.vertex != null) {
                    this.graph.getGraphLayoutCache().update(this.vertex);
                }
                if (this.contextViews != null) {
                    this.graph.getGraphLayoutCache().update(this.contextViews);
                }
            }
            this.overlay(graphics);
            if (this.offscreen != null) {
                rectangle.add(this.graph.toScreen(new Rectangle(this.vertex.getBounds())));
                object = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (object != null) {
                    rectangle.add((Rectangle)object);
                }
                rectangle.grow(2, 2);
                n = Math.max(0, rectangle.x);
                int n2 = Math.max(0, rectangle.y);
                int n3 = n + rectangle.width;
                int n4 = n2 + rectangle.height;
                this.graph.getGraphics().drawImage(this.offscreen, n, n2, n3, n4, n, n2, n3, n4, this.graph);
            }
        }

        protected Rectangle computeBounds(MouseEvent mouseEvent) {
            int n = this.initialBounds.x;
            int n2 = this.initialBounds.x + this.initialBounds.width - 1;
            int n3 = this.initialBounds.y;
            int n4 = this.initialBounds.y + this.initialBounds.height - 1;
            Point point = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
            point.x = Math.max(0, point.x);
            point.y = Math.max(0, point.y);
            if (this.index > 4) {
                n4 = point.y;
            } else if (this.index < 3) {
                n3 = point.y;
            }
            if (this.index == 0 || this.index == 3 || this.index == 5) {
                n = point.x;
            } else if (this.index == 2 || this.index == 4 || this.index == 7) {
                n2 = point.x;
            }
            int n5 = n2 - n;
            int n6 = n4 - n3;
            if (VertexView.this.isConstrainedSizeEvent(mouseEvent)) {
                if (this.index == 3 || this.index == 4 || this.index == 5) {
                    n6 = n5;
                } else if (this.index == 1 || this.index == 6 || this.index == 2 || this.index == 7) {
                    n5 = n6;
                } else {
                    n6 = n5;
                    n3 = n4 - n6;
                }
            }
            if (n5 < 0) {
                n += n5;
                n5 = Math.abs(n5);
            }
            if (n6 < 0) {
                n3 += n6;
                n6 = Math.abs(n6);
            }
            return new Rectangle(n, n3, n5 + 1, n6 + 1);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.index != -1) {
                this.cachedBounds = this.computeBounds(mouseEvent);
                this.vertex.setBounds(this.cachedBounds);
                Object[] objectArray = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                Map map = GraphConstants.createAttributes(objectArray, null);
                this.graph.getGraphLayoutCache().edit(map, null, null, null);
            }
            mouseEvent.consume();
            this.cachedBounds = null;
            this.initialBounds = null;
            this.firstDrag = true;
        }

        private void invalidate() {
            Rectangle rectangle = this.graph.getCellBounds(this.vertex.getCell());
            if (rectangle != null) {
                rectangle = new Rectangle(rectangle);
                this.graph.toScreen(rectangle);
                int n = this.graph.getHandleSize();
                int n2 = 2 * n;
                int n3 = rectangle.x - n;
                int n4 = rectangle.y - n;
                int n5 = rectangle.x + rectangle.width / 2 - n;
                int n6 = rectangle.y + rectangle.height / 2 - n;
                int n7 = rectangle.x + rectangle.width - n;
                int n8 = rectangle.y + rectangle.height - n;
                this.r[0].setBounds(n3, n4, n2, n2);
                this.r[1].setBounds(n5, n4, n2, n2);
                this.r[2].setBounds(n7, n4, n2, n2);
                this.r[3].setBounds(n3, n6, n2, n2);
                this.r[4].setBounds(n7, n6, n2, n2);
                this.r[5].setBounds(n3, n8, n2, n2);
                this.r[6].setBounds(n5, n8, n2, n2);
                this.r[7].setBounds(n7, n8, n2, n2);
            }
        }
    }
}

