% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforcecom.getBatchDetails.R
\name{rforcecom.getBatchDetails}
\alias{rforcecom.getBatchDetails}
\title{Returning the Details of a Batch in a Bulk API Job}
\usage{
rforcecom.getBatchDetails(session, jobId, batchId)
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{jobId}{a character string defining the salesforce id assigned to a submitted job as returned by \link{rforcecom.createBulkJob}}

\item{batchId}{a character string defining the salesforce id assigned to a submitted batch as returned by \link{rforcecom.createBulkBatch}}
}
\value{
A \code{data.frame}, formatted by salesforce, with information containing the success or failure or certain rows in a submitted batch, 
unless the operation was query, then it is a data.frame containing the resultId for retrieving the recordset.
}
\description{
This function returns detailed (row-by-row) information on an existing batch
which has already been submitted to Bulk API Job
}
\examples{
\dontrun{
batch_details <- rforcecom.getBatchDetails(session, jobId=job_info$id, batchId=batches_info[[1]]$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
\concept{
bulk batch salesforce api
}

