% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.to.data.set.R
\name{fit.to.data.set}
\alias{fit.to.data.set}
\title{fit.to.data.set}
\usage{
fit.to.data.set(
  df,
  imp,
  debug.flag = 0,
  plot.string = "",
  temp.dir = NULL,
  try.counter = 3,
  return.all = FALSE
)
}
\arguments{
\item{df, }{contains x and y, midpoints and counts from a histogram of imp}

\item{imp}{importances}

\item{debug.flag}{debug flag}

\item{plot.string, }{file name for a debugging plot}

\item{temp.dir, }{directory for debugging output}

\item{try.counter}{try.counter=1 my.dsn xi=  1
try.counter=2  xi=  mean(x)
try.counter=3 start xi, omega, lambda from the parameters retuned by fitdistrplus::fitdist}

\item{return.all}{TRUE, return the full ouput of minpack.lm::nlsLM,
FALSE , return summary of parameters}
}
\value{
If the skew-normal fitting routine is succesful, then the matrix of parmaters and standard errors is returned.
-- othewise a "try-error" message is returned
}
\description{
This function fit a skew normal to a set of data
}
\examples{
data(imp20000)                                      
imp<-log(imp20000$importances)                               
t2<-imp20000$counts
temp<-imp[t2 > 1]   #see                          
temp<-temp[temp != -Inf]                         
temp <- temp - min(temp) + .Machine$double.eps   
f_fit <- f.fit(temp)                             
y <- f_fit$zh$density                            
x <- f_fit$midpoints                             
df <- data.frame(x, y)                           
fitted_parameters <- fit.to.data.set(df, temp, try.counter = 3)           
fitted_parameters

hist(temp, breaks = 200, freq = FALSE)
lines(df$x, df$y, type = "l", col = "green", lwd = 2, 
      xlim = c(0, max(df$x) + 0.5))
curve(sn::dsn(x, xi = fitted_parameters$Estimate[1], omega = fitted_parameters$Estimate[2], 
              alpha = fitted_parameters$Estimate[3]), add = TRUE, 
                col = "purple", lwd = 3, xlim = c(0, 16))
curve(my.dsn(x, xi = fitted_parameters$Estimate[1], omega = fitted_parameters$Estimate[2],  
                lambda = fitted_parameters$Estimate[3]), add = TRUE, 
                col = "orange", lwd = 3)

\donttest{
library(RFlocalfdr.data)
data(ch22)                                       
imp<-log(ch22$imp)                               
t2<-ch22$C                                       
temp<-imp[t2 > 30]   #                           
temp<-temp[temp != -Inf]                         
temp <- temp - min(temp) + .Machine$double.eps   
f_fit <- f.fit(temp)                             
y <- f_fit$zh$density                            
x <- f_fit$midpoints                             
df <- data.frame(x, y)                           
mm.df3 <- fit.to.data.set(df, temp)              
mm.df3
##              Estimate Std..Error  t.value     Pr...t..
## xi.xi        1.102303 0.03669284 30.04136 1.485263e-56
## omega.omega  1.246756 0.04716184 26.43569 6.276349e-51
## lambda.alpha 1.799169 0.17343872 10.37351 3.103195e-18
}
}
