% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{ggplot.resi}
\alias{ggplot.resi}
\title{Plotting RESI Estimates and CIs}
\usage{
\method{ggplot}{resi}(data, mapping, alpha = NULL, error.bars = TRUE, ..., environment)
}
\arguments{
\item{data}{Object of `resi`, `summary_resi`, or `anova_resi` class}

\item{mapping}{Ignored, included for consistency with `ggplot` generic}

\item{alpha}{Numeric, desired alpha level for confidence intervals}

\item{error.bars}{Logical, whether to include end caps on the confidence intervals. Default = `TRUE`}

\item{...}{Ignored}

\item{environment}{Ignored, included for consistency with `ggplot` generic}
}
\value{
Returns a ggplot of RESI point estimates
}
\description{
This function uses ggplot2 graphics to plot robust effect size (RESI) estimates and confidence intervals
from `resi`, `summary_resi`, and `anova_resi` objects.
}
\examples{
# create a resi object
resi_obj <- resi(lm(charges ~ region * age + bmi + sex, data = RESI::insurance),
nboot = 10)

# plot ANOVA table
ggplot2::ggplot(anova(resi_obj))
}
