% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S2Rsq.R
\name{S2Rsq}
\alias{S2Rsq}
\title{Covert S to R^2}
\usage{
S2Rsq(S)
}
\arguments{
\item{S}{Numeric, the robust effect size index.}
}
\value{
Returns an estimate of R^2 based on the RESI
}
\description{
Converts robust effect size index (S) to R^2, the partial
coefficient of determination, using the formula from Vandekar, Tao, & Blume (2020).
}
\details{
The formula for the conversion is:

\eqn{ R^2 = S^2 / (1 + S^2)}
}
\examples{
# fit a simple linear regression with a binary predictor
mod = lm(charges ~ sex, data = RESI::insurance)

# calculate t-value
t = summary(mod)$coefficients[2, "t value"]

# calculate RESI (S)
S = t2S(t, n = 1338, rdf = 1336)

# convert S to R^2
S2Rsq(S)

}
