% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t2S.R
\name{t2S}
\alias{t2S}
\title{Compute the robust effect size index estimate from t statistic (default)}
\usage{
t2S(t, n, rdf)
}
\arguments{
\item{t}{The t statistic for the parameter of interest.}

\item{n}{Number of independent samples.}

\item{rdf}{Model residual degrees of freedom/degrees of freedom of the T statistic.}
}
\value{
Returns a scalar or vector argument of the the robust effect size index estimate.
}
\description{
This function computes the robust effect size index from Vandekar, Rao, & Blume (2020).
Vector arguments are accepted. If different length arguments are passed they are dealt with in the usual way of R.
}
\details{
This function computes S, the RESI, from a T statistic using the default
formula. There is another function, \code{\link{t2S_alt}}, that uses an alternative
formula. This function's formula is derived by solving the expected value of the
T statistic for S. It is unbiased and consistent.

The formula for the conversion is:

\eqn{S = (t * \sqrt(2) * \Gamma(rdf/2)) / (\sqrt(n * rdf) * \Gamma((rdf - 1)/2))}
}
\examples{
# to obtain t values, first fit a lm
mod = lm(charges ~ region * age + bmi + sex, data = RESI::insurance)
# run lmtest::coeftest to get t values, using a robust variance-covariance formula
ts = lmtest::coeftest(mod, vcov. = sandwich::vcovHC)[,'t value']

# get RESI estimates
t2S(ts, n = nrow(RESI::insurance), rdf = mod$df.residual)

}
