/*
 * Decompiled with CFR 0.152.
 */
package ihm.graphique;

import ihm.Analyse;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javalain.math.Calcul;
import javax.swing.JPanel;
import util.GuiUtils;

public class Histogramme
extends JPanel {
    private final int echelle_fenetre = 100;
    private final int marge = 20;
    private Analyse frAnalyse;
    private double[] donnees_x;
    private double ecart_type;
    private double moyenne;
    private int largeur;
    private int hauteur;
    private int centre_y;
    private int decal_x;
    private double unite_x;
    private int axe_x_min;
    private int lg_x;
    private boolean atypique;
    private int valAtypique;
    private boolean selection = false;
    private boolean en_selection = false;
    private int x_debut;
    private int x_fin;
    public double x0;
    public double x1;
    private String fichier_donnees = "";
    private String nomIndice;
    private String nomMethode;

    public Histogramme(int l, int h, boolean atypique, boolean selection_souris, Analyse analyse) {
        this.largeur = l * this.echelle_fenetre + 2 * this.marge;
        this.hauteur = h * this.echelle_fenetre + 2 * this.marge;
        this.setMinimumSize(new Dimension(this.largeur, this.hauteur));
        this.setPreferredSize(new Dimension(this.largeur, this.hauteur));
        this.centre_y = this.hauteur - 82;
        this.atypique = atypique;
        this.frAnalyse = analyse;
        if (selection_souris) {
            ComportementSouris souris = new ComportementSouris();
            this.addMouseListener(souris);
            this.addMouseMotionListener(souris);
        }
    }

    public void setProjection(double[] a) {
        if (this.donnees_x == null || this.donnees_x.length != a.length) {
            this.donnees_x = new double[a.length];
        }
        System.arraycopy(a, 0, this.donnees_x, 0, a.length);
        this.ecart_type = Calcul.ecartType(this.donnees_x);
        this.moyenne = Calcul.moyenne(this.donnees_x);
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.donnees_x.length; ++i) {
            if (this.donnees_x[i] < min) {
                min = this.donnees_x[i];
                continue;
            }
            if (!(this.donnees_x[i] > max)) continue;
            max = this.donnees_x[i];
        }
        this.axe_x_min = (int)min + (min < 0.0 ? -1 : 0);
        int axe_x_max = (int)max + (max > 0.0 ? 1 : 0);
        this.lg_x = axe_x_max - this.axe_x_min;
        this.unite_x = (float)(this.largeur - 2 * this.marge) / (float)this.lg_x;
        this.decal_x = (int)(((double)(this.largeur - 2 * this.marge) - this.unite_x * (double)this.lg_x) / 2.0 + (double)this.marge);
        this.selection = false;
        this.en_selection = false;
    }

    public void setFichierDonnees(String f) {
        this.fichier_donnees = f;
    }

    public void setValeurAtypiques(int i) {
        this.valAtypique = i;
    }

    public double getBorneInfSelect() {
        return this.x0;
    }

    public double getBorneSupSelect() {
        return this.x1;
    }

    public boolean isSelection() {
        return this.selection;
    }

    public void setSelection(boolean b, double x0, double x1) {
        this.selection = b;
        this.x0 = x0;
        this.x1 = x1;
        this.x_debut = (int)((x0 - (double)this.axe_x_min) * this.unite_x + (double)this.decal_x);
        this.x_fin = (int)((x1 - (double)this.axe_x_min) * this.unite_x + (double)this.decal_x);
    }

    public double[] getDonnees() {
        return this.donnees_x;
    }

    public void setInfos(String nomIndice, String nomMethode) {
        this.nomIndice = nomIndice;
        this.nomMethode = nomMethode;
    }

    @Override
    public void paint(Graphics g) {
        int tps;
        int i;
        if (this.donnees_x == null) {
            return;
        }
        g.setColor(GuiUtils.GRIS_238);
        g.fillRect(0, 0, this.largeur, this.hauteur);
        int pas_x = 1;
        if (this.lg_x >= 10) {
            pas_x = this.lg_x >= 20 ? this.lg_x / 10 : 2;
        }
        g.setFont(GuiUtils.FONT_11);
        g.setColor(Color.GRAY);
        g.drawLine(this.decal_x, this.centre_y, this.decal_x + (int)(this.unite_x * (double)this.lg_x), this.centre_y);
        for (i = 0; i <= this.lg_x; ++i) {
            if (i % pas_x != 0) continue;
            tps = this.decal_x + (int)((double)i * this.unite_x);
            g.drawString("" + (i + this.axe_x_min), tps, this.centre_y + 15);
            g.drawLine(tps, this.centre_y - 3, tps, this.centre_y + 3);
        }
        int nb_hist = 100;
        if (this.fichier_donnees.startsWith("gorille")) {
            nb_hist = 30;
        } else if (this.fichier_donnees.startsWith("lub")) {
            nb_hist = 40;
        } else if (this.fichier_donnees.startsWith("don")) {
            nb_hist = 50;
        } else if (this.fichier_donnees.equals("olive.txt")) {
            nb_hist = 80;
        } else if (this.fichier_donnees.equals("oliveA.txt")) {
            nb_hist = 80;
        } else if (this.fichier_donnees.equals("olive3.txt")) {
            nb_hist = 40;
        } else if (this.fichier_donnees.startsWith("fiab")) {
            nb_hist = 200;
        }
        int[] histogramme = new int[nb_hist];
        boolean[] isAtypique = new boolean[nb_hist];
        for (i = 0; i < this.donnees_x.length; ++i) {
            int k = (int)((this.donnees_x[i] - (double)this.axe_x_min) * (double)nb_hist / (double)this.lg_x);
            try {
                int n = k;
                histogramme[n] = histogramme[n] + 1;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("axe_x_min = " + this.axe_x_min);
                System.out.println("lg_x = " + this.lg_x);
                System.out.println("i = " + i);
                System.out.println("donnees_x[i] = " + this.donnees_x[i]);
                System.out.println("nb_hist = " + nb_hist);
                System.out.println("calcul = " + (this.donnees_x[i] - (double)this.axe_x_min) * (double)nb_hist / (double)this.lg_x);
            }
            if (!this.atypique) continue;
            isAtypique[k] = this.atypique && this.valAtypique != 0 && (this.donnees_x[i] < this.moyenne - this.ecart_type * (double)this.valAtypique || this.donnees_x[i] > this.moyenne + this.ecart_type * (double)this.valAtypique);
        }
        double max = 0.0;
        for (i = 0; i < nb_hist; ++i) {
            if (!((double)histogramme[i] > max)) continue;
            max = histogramme[i];
        }
        boolean affiche = false;
        for (i = 0; i < nb_hist; ++i) {
            if (histogramme[i] == 0) continue;
            g.setColor(isAtypique[i] ? Color.ORANGE : Color.GRAY);
            tps = Math.max(2, (int)((double)(histogramme[i] * (this.centre_y - this.marge)) / max));
            g.fillRect(this.decal_x + (int)((double)i * this.unite_x * (double)this.lg_x / (double)nb_hist), this.centre_y - tps, (int)(this.unite_x * (double)this.lg_x / (double)nb_hist) + 1, tps + 1);
            if (affiche || (double)histogramme[i] != max) continue;
            affiche = true;
            g.setColor(Color.LIGHT_GRAY);
            g.drawString("" + (int)max, this.decal_x + (int)((double)i * this.unite_x * (double)this.lg_x / (double)nb_hist), this.centre_y - tps - 5);
        }
        if (this.en_selection || this.selection) {
            g.setColor(Color.BLACK);
            g.drawLine(this.x_debut, this.centre_y - 8, this.x_debut, this.centre_y + 8);
            g.drawLine(this.x_fin, this.centre_y - 8, this.x_fin, this.centre_y + 8);
            g.drawRect(this.x_debut - 3, this.centre_y - 3, 6, 6);
            g.drawRect(this.x_fin - 3, this.centre_y - 3, 6, 6);
            g.drawString(GuiUtils.DECIMAL_2.format(this.x0), this.x_debut - 3, this.centre_y - 10);
            g.drawString(GuiUtils.DECIMAL_2.format(this.x1), this.x_fin - 3, this.centre_y - 10);
        }
        if (this.fichier_donnees.startsWith("lub")) {
            g.setColor(Color.blue);
            for (i = 0; i < 21; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.black);
            for (i = 21; i < 43; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
            g.setColor(Color.green);
            for (i = 43; i < 74; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 44, 3, 11);
            }
        } else if (this.fichier_donnees.startsWith("don3") || this.fichier_donnees.startsWith("don4")) {
            g.setColor(Color.blue);
            for (i = 0; i < 190; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.black);
            for (i = 190; i < 200; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
        } else if (this.fichier_donnees.startsWith("don1") || this.fichier_donnees.startsWith("don2")) {
            g.setColor(Color.blue);
            for (i = 0; i < 100; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.black);
            for (i = 100; i < 200; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
        } else if (this.fichier_donnees.startsWith("fiab")) {
            g.setColor(Color.blue);
            for (i = 0; i < this.donnees_x.length; ++i) {
                g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 20, 3, 11);
            }
        } else if (this.frAnalyse != null && this.fichier_donnees.startsWith("olive")) {
            String filePath1 = this.frAnalyse.getIhm().getParametre().rep_donnees + File.separatorChar + "olive.txt";
            String filePath2 = this.frAnalyse.getIhm().getParametre().rep_donnees + File.separatorChar + this.fichier_donnees;
            BufferedReader buffer1 = null;
            BufferedReader buffer2 = null;
            try {
                FileReader fichier1 = new FileReader(filePath1);
                FileReader fichier2 = new FileReader(filePath2);
                buffer1 = new BufferedReader(fichier1);
                buffer2 = new BufferedReader(fichier2);
                buffer2.readLine();
                buffer2.readLine();
            }
            catch (Exception e) {
                // empty catch block
            }
            int num = 0;
            for (i = 0; i < this.donnees_x.length; ++i) {
                try {
                    String ch = buffer2.readLine();
                    ch = ch.replace(".0", "");
                    while (!buffer1.readLine().equals(ch)) {
                        ++num;
                    }
                    if (num - 2 >= 521) {
                        g.setColor(Color.cyan);
                        g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 68, 1, 11);
                    } else if (num - 2 >= 471) {
                        g.setColor(Color.magenta);
                        g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 56, 1, 11);
                    } else if (num - 2 >= 421) {
                        g.setColor(Color.pink);
                        g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 44, 1, 11);
                    } else if (num - 2 >= 388) {
                        g.setColor(Color.yellow);
                        g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 32, 1, 11);
                    } else if (num - 2 >= 323) {
                        g.setColor(Color.orange);
                        g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 20, 1, 11);
                    } else if (num - 2 >= 287) {
                        g.setColor(Color.red);
                        g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 56, 1, 11);
                    } else if (num - 2 >= 81) {
                        g.setColor(Color.green);
                        g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 44, 1, 11);
                    } else if (num - 2 >= 25) {
                        g.setColor(Color.black);
                        g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 32, 1, 11);
                    } else if (num - 2 >= 0) {
                        g.setColor(Color.blue);
                        g.fillRect((int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 20, 1, 11);
                    }
                    ++num;
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Erreur dans la recherche dans le fichier olive.txt original.");
                    System.exit(0);
                }
            }
        } else if (this.fichier_donnees.startsWith("gorille")) {
            g.setColor(Color.blue);
            for (i = 0; i < 29; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.black);
            for (i = 29; i < 59; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
        } else if (this.fichier_donnees.startsWith("ruspini")) {
            g.setColor(Color.blue);
            for (i = 0; i < 20; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.black);
            for (i = 20; i < 43; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
            g.setColor(Color.yellow);
            for (i = 43; i < 60; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 44, 3, 11);
            }
            g.setColor(Color.red);
            for (i = 60; i < 75; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 56, 3, 11);
            }
        } else if (this.fichier_donnees.startsWith("donsimu83")) {
            g.setColor(Color.blue);
            for (i = 0; i < 100; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.black);
            for (i = 100; i < 150; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
            g.setColor(Color.green);
            for (i = 150; i < 200; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 44, 3, 11);
            }
        } else if (this.fichier_donnees.startsWith("normale2")) {
            g.setColor(Color.blue);
            for (i = 0; i < 500; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.red);
            for (i = 500; i < 1000; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
        } else if (this.fichier_donnees.startsWith("normale4")) {
            g.setColor(Color.blue);
            for (i = 0; i < 250; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.pink);
            for (i = 250; i < 500; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
            g.setColor(Color.red);
            for (i = 500; i < 750; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 44, 3, 11);
            }
            g.setColor(Color.orange);
            for (i = 750; i < 1000; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 56, 3, 11);
            }
        } else if (this.fichier_donnees.startsWith("normale10")) {
            g.setColor(Color.blue);
            for (i = 0; i < 100; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.pink);
            for (i = 100; i < 200; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
            g.setColor(Color.red);
            for (i = 200; i < 300; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 44, 3, 11);
            }
            g.setColor(Color.orange);
            for (i = 300; i < 400; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 56, 3, 11);
            }
            g.setColor(Color.green);
            for (i = 400; i < 500; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 68, 3, 11);
            }
            g.setColor(Color.yellow);
            for (i = 500; i < 600; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 20, 3, 11);
            }
            g.setColor(Color.black);
            for (i = 600; i < 700; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 32, 3, 11);
            }
            g.setColor(Color.magenta);
            for (i = 700; i < 800; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 44, 3, 11);
            }
            g.setColor(Color.cyan);
            for (i = 800; i < 900; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 56, 3, 11);
            }
            g.setColor(Color.gray);
            for (i = 900; i < 1000; ++i) {
                tps = (int)((this.donnees_x[i] - (double)this.axe_x_min) * this.unite_x) + this.decal_x;
                g.fillRect(tps - 1, this.centre_y + 68, 3, 11);
            }
        } else if (this.fichier_donnees.equals("QN_BadPart300.txt")) {
            g.setColor(Color.blue);
            g.fillRect((int)((this.donnees_x[299] - (double)this.axe_x_min) * this.unite_x) + this.decal_x - 1, this.centre_y + 20, 2, 11);
        }
    }

    final class ComportementSouris
    extends MouseAdapter {
        ComportementSouris() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            Histogramme.this.selection = false;
            Histogramme.this.en_selection = true;
            Histogramme.this.x_debut = evt.getX();
            Histogramme.this.x_fin = Histogramme.this.x_debut;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            Histogramme.this.en_selection = false;
            if (Histogramme.this.x_debut == Histogramme.this.x_fin) {
                Histogramme.this.selection = false;
                Histogramme.this.x_debut = 0;
                Histogramme.this.x_fin = 0;
                Histogramme.this.repaint();
                Histogramme.this.frAnalyse.setEnabledSaveSelection(false);
            } else {
                Histogramme.this.frAnalyse.setEnabledSaveSelection(true);
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (Histogramme.this.en_selection) {
                Histogramme.this.selection = true;
                Histogramme.this.x_fin = evt.getX();
                Histogramme.this.x0 = (double)(Histogramme.this.x_debut - Histogramme.this.decal_x) / Histogramme.this.unite_x + (double)Histogramme.this.axe_x_min;
                Histogramme.this.x1 = (double)(Histogramme.this.x_fin - Histogramme.this.decal_x) / Histogramme.this.unite_x + (double)Histogramme.this.axe_x_min;
                Histogramme.this.repaint();
            }
        }
    }
}

