/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction.multiobjectif;

import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.DominanceMinComparator;
import javalain.math.Calcul;
import javalain.math.fonction.Fct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZDT4
extends Fct {
    private static final double cte = Math.PI * 4;

    public ZDT4() {
        this(10);
    }

    public ZDT4(int nbVariable) {
        this.nomFct = "ZDT4";
        this.nbVariable = nbVariable;
        this.nbFctObjectif = 2;
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        this.lowerLimit[0] = 0.0;
        this.upperLimit[0] = 1.0;
        for (int i = 1; i < this.nbVariable; ++i) {
            this.lowerLimit[i] = -5.0;
            this.upperLimit[i] = 5.0;
        }
    }

    @Override
    public double[] compute(double[] x) {
        double[] fct = new double[this.nbFctObjectif];
        double g = ZDT4.g(x);
        fct[0] = x[0];
        fct[1] = g * ZDT4.f(fct[0], g);
        return fct;
    }

    @Override
    public double[][] getFront() {
        if (this.front == null) {
            this.readParetoFront("ZDT4.pf");
        }
        return this.front;
    }

    public static double g(double[] x) {
        double somme = 0.0;
        for (int i = 1; i < x.length; ++i) {
            somme += Calcul.pow2(x[i]) - 10.0 * Math.cos(Math.PI * 4 * x[i]);
        }
        return 1.0 + 10.0 * (double)(x.length - 1) + somme;
    }

    public static double f(double f1, double g) {
        return 1.0 - Math.sqrt(f1 / g);
    }

    @Override
    public Comparator<SolutionEA> comparator() {
        return new DominanceMinComparator();
    }
}

