% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{DataProcessing}
\alias{DataProcessing}
\title{DataProcessing}
\usage{
DataProcessing(chipType = "HuEx-1_0-st-v2", tags = "coreR3,A20071112,EP",
  Name = "ColonCancer", ExonSummarization = TRUE,
  GeneSummarization = TRUE, FIRMA = TRUE, location = NULL,
  verbose = TRUE)
}
\arguments{
\item{chipType}{The name of the chip type of the array data.}

\item{tags}{Tags that is added to the chipType.}

\item{Name}{The name of the data.}

\item{ExonSummarization}{Logical. Should the data be summarized at the exon level?}

\item{GeneSummarization}{Logical. Should the data be summarized at the gene level?}

\item{FIRMA}{Logical. Should the FIRMA model be performed on the data?}

\item{location}{The location where the .rda file is to be stored. If NULL, a list containing the requested objects is returned to the user.}

\item{verbose}{Logical. If TRUE, messages are printed during the data processing.}
}
\value{
An .rda file that is saved at the specified location.
}
\description{
The DataProcessing function processes raw .CEL files to probe intensities values with the help of functions of the aroma.affymetrix package. It returns a data frame and saves it as an .RData file.
}
\details{
The DataProcessing function is a wrapper of several functions of the aroma.affymetrix package. To obtain the data to perform the REIDS model on the raw .CEL files are 
background corrected with the rma background correction and normalization is performed with the quantile normalization. In order for the function to run properly, a chipType and
its possible tags need to be specified. It is also important to have the same folder structure as required by the aroma.affymetrix package. This implies the following:
a rawData folder with therein a folder with the "Name" parameter. This "Name" folder should contain a folder with the chipType name and herein the .CEL files should be placed.
Also a folder annotationData should be present. Herein a folder chipTypes should be make which contains folders for type of chips with the respective names. In the folder of
each chiptype the corresponding .cdf file should be saved. If specified, the processed data will be saved at a specific location as a data frame with the first colum the gene IDs and the second column the exon IDs. All
other columns contain the sample values. Further the object also contains a vector of the unique gene ID and a vector of the  unique exon IDs. If requested, exon and gene level summarization are performed and saved as data frames at the specified location. Further,the option is provided to perform the FIRMA model on the data as well.
}
\examples{
\dontrun{
DataProcessing(chipType="HTA-2_0",tags="*,r",Name="HTAData",
ExonSummarization=TRUE,GeneSummarization=TRUE,FIRMA=TRUE,
location="HTAData",verbose=TRUE)
}
}
