#' Positions
#' 
#' Genome location of the probe sets of TC12000010
#' 
#' @name TC12000010_positions
#' 
#' @usage data(TC12000010_positions)
#' 
#' @format An object of class \code{"data.frame"}.
#' @examples
#' data(TC12000010_positions)
NULL

#' Transcript Clusters
#' 
#' Transcript cluster compositions of TC12000010
#' 
#' @name TC12000010_transcript.clusters
#'
#' @usage data(TC12000010_transcript.clusters)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(TC12000010_transcript.clusters)
NULL

#' Example data set
#' 
#' An example data set containing the expression values of the probe sets of transcript cluster TC12000010.
#' 
#' @name TC12000010
#' 
#' @docType data
#'
#' @usage data(TC12000010)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(TC12000010)
NULL

#' Example data set for FIRMA
#' 
#' An example data set for the FIRMA functions
#' 
#' @name ExampleFirmaOutput
#' 
#' @docType data
#'
#' @usage data(ExampleFirmaOutput)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(ExampleFirmaOutput)
NULL

#' Exon level data
#' 
#' An example data set containing the summarized expression values on the exon level of the probe sets of TC12000010.
#' 
#' @name TC12000010_ExonLevel
#' 
#' @docType data
#'
#' @usage data(TC12000010_ExonLevel)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(TC12000010_ExonLevel)
NULL

#' REIDS Output
#' 
#' An example data set containing the obtained REIDS values of TC12000010.
#' 
#' @name TC12000010_REIDS_Output
#' 
#' @docType data
#'
#' @usage data(TC12000010_REIDS_Output)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(TC12000010_REIDS_Output)
NULL

#' Gene level data
#' 
#' An example data set containing the summarized expression value of TC12000010.
#' 
#' @name TC12000010_GeneLevel
#' 
#' @docType data
#'
#' @usage data(TC12000010_GeneLevel)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(TC12000010_GeneLevel)
NULL