% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{REIDSFunction}
\alias{REIDSFunction}
\title{"REIDSFunction"}
\usage{
REIDSFunction(geneData, nsim = 1000, geneID, exonID,
  informativeCalls = TRUE, alpha = 0.5)
}
\arguments{
\item{geneData}{The data with as rows the probesets and as columns the samples. Note that the first column should contain the gene IDs and the second column the exon IDs}

\item{nsim}{The number of iterations to perform.}

\item{geneID}{A vector of the gene IDs.}

\item{exonID}{A vector of the exon IDs}

\item{informativeCalls}{Logical. Should the I/NI calls method be perform before applying the REIDS model?}

\item{alpha}{The threshold for filtering in the I/NI calls method. Probesets with scores higher than alpha are kept.}
}
\value{
A list with an element for each gene with per gene the values returned by the iniREIDS and REIDS functions.
}
\description{
The REIDSFunction performs the REIDS model on the output of the DataProcessing function and is a regular R function. It is advised to use this function in its cluster version and not on a regular laptop as it will consume time and memory.
}
\examples{
data(ExampleData)
 
Test=REIDSFunction(geneData=ExampleData,nsim=10,geneID=ExampleData[,1],exonID=ExampleData[,2],
informativeCalls=TRUE,alpha=0.5)
}
