% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{ASREIDSRanking}
\alias{ASREIDSRanking}
\title{ASREIDSRanking}
\usage{
ASREIDSRanking(ASProbeSets, AnnotData, Data, mode = c("All", "Conservative",
  "Liberal"))
}
\arguments{
\item{ASProbeSets}{The AS probe sets as identified by ASExons}

\item{AnnotData}{An annotation containing the junctions for each probe set.}

\item{Data}{The Data on which testing of the array scores should be conducted.}

\item{mode}{A character string which is either "All", "Conservative" or "Liberal" indicating the junction filtering mode.}
}
\value{
A data frame with one line per exon. The columns contain the gene ID, the exon ID, the supporting junctions, the LRT score, Chi-Squared value and a support category.
}
\description{
The ASREIDSRanking functions ranks the identified AS exons based on their 5'end and 3'end junction support.
}
\examples{
data(ExampleData)
data(AnnotationExampleData)
Test=REIDSFunction(geneData=ExampleData,nsim=100,geneID=ExampleData[,1],exonID=ExampleData[,2],
informativeCalls=TRUE,alpha=0.5)
ExonTest=ExonTesting(Data=Test,Exonthreshold=NULL,groups=list(group1=c(1,2,3),group2=c(4,5,6)),
paired=FALSE,significancelevel=NULL)
ASTest=ASExons(Data=Test,Exonthreshold=0.5,groups=list(group1=c(1,2,3),group2=c(4,5,6)),
paired=FALSE,significancelevel=0.05)
RankTest=ASREIDSRanking(ASProbeSets=ASTest[,2],AnnotData=AnnotationExampleData,Data=ExampleData,
mode="All")
}
