% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-users-export.R
\name{redcap_users_export}
\alias{redcap_users_export}
\title{List authorized users}
\usage{
redcap_users_export(
  redcap_uri,
  token,
  verbose = TRUE,
  config_options = NULL,
  handle_httr = NULL
)
}
\arguments{
\item{redcap_uri}{The
\href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{uri}/url
of the REDCap server
typically formatted as "https://server.org/apps/redcap/api/".
Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  The verbose output might contain
sensitive information (\emph{e.g.} PHI), so turn this off if the output might
be visible somewhere public. Optional.}

\item{config_options}{A list of options passed to \code{\link[httr:POST]{httr::POST()}}.
See details at \code{\link[httr:httr_options]{httr::httr_options()}}. Optional.}

\item{handle_httr}{The value passed to the \code{handle} parameter of
\code{\link[httr:POST]{httr::POST()}}.
This is useful for only unconventional authentication approaches.  It
should be \code{NULL} for most institutions.  Optional.}
}
\value{
\itemize{
\item \code{data_user}: A \code{\link[tibble:tibble]{tibble::tibble()}} of all users associated with the project.
One row represents one user.
\item \code{data_user_form}: A \code{\link[tibble:tibble]{tibble::tibble()}} of permissions for users and forms.
One row represents a unique user-by-form combination.
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_codes}: A collection of
\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status codes},
separated by semicolons.  There is one code for each batch attempted.
\item \code{outcome_messages}: A collection of human readable strings indicating the
operations' semicolons.  There is one code for each batch attempted.  In an
unsuccessful operation, it should contain diagnostic information.
\item \code{elapsed_seconds}: The duration of the function.
}
}
\description{
List users authorized for a project.
}
\note{
\strong{Documentation in REDCap 8.4.0}

\if{html}{\out{<div class="sourceCode">}}\preformatted{This method allows you to export the list of users for a project,
including their user privileges and also email address, first name,
and last name.

Note: If the user has been assigned to a user role, it will return
the user with the role's defined privileges.
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
uri      <- "https://bbmc.ouhsc.edu/redcap/api/"
token    <- "06DEFB601F9B46847DAA9DF0CFA951B4"
result   <- REDCapR::redcap_users_export(redcap_uri=uri, token=token)
result$data_user
result$data_user_form
}
}
