% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_record.R
\name{format_record}
\alias{format_record}
\title{Format Record}
\usage{
format_record(x, metadata = NULL, col_type = NULL, ...)
}
\arguments{
\item{x}{a \code{rcer_rccore}, \code{rcer_raw_record}, or \code{rcer_record} object.}

\item{metadata}{a \code{rcer_metadata} or \code{rcer_raw_metadata} object.
Will be ignored if \code{col_type} is defined.}

\item{col_type}{a \code{rcer_col_type} object.}

\item{...}{other arguments passed to \code{\link{col_type}}}
}
\value{
A \code{data.frame}
}
\description{
Use REDCap project metadata to build a well formatted \code{data.frame} for
the record.
}
\examples{

data("avs_raw_metadata")
data("avs_raw_record")

# Formatting the record can be called in different ways and the same result
# will be generated
identical(
  format_record(avs_raw_record, avs_raw_metadata),
  format_record(avs_raw_core)
)

avs <- format_record(avs_raw_record, avs_raw_metadata)
avs

}
\seealso{
\code{\link{export_core}}, \code{\link{export_content}}, \code{vignette("formatting", package = "REDCapExporter")}
}
