% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds2dd.R
\name{ds2dd}
\alias{ds2dd}
\title{Data set to data dictionary function}
\usage{
ds2dd(
  ds,
  record.id = "record_id",
  form.name = "basis",
  field.type = "text",
  field.label = NULL,
  include.column.names = FALSE,
  metadata = names(redcapcast_meta)
)
}
\arguments{
\item{ds}{data set}

\item{record.id}{name or column number of id variable, moved to first row of
data dictionary, character of integer. Default is "record_id".}

\item{form.name}{vector of form names, character string, length 1 or length
equal to number of variables. Default is "basis".}

\item{field.type}{vector of field types, character string, length 1 or length
equal to number of variables. Default is "text.}

\item{field.label}{vector of form names, character string, length 1 or length
equal to number of variables. Default is NULL and is then identical to field
names.}

\item{include.column.names}{Flag to give detailed output including new
column names for original data set for upload.}

\item{metadata}{Metadata column names. Default is the included
REDCapCAST::redcapcast_data.}
}
\value{
data.frame or list of data.frame and vector
}
\description{
Migrated from stRoke ds2dd(). Fits better with the functionality of
'REDCapCAST'
}
\examples{
redcapcast_data$record_id <- seq_len(nrow(redcapcast_data))
ds2dd(redcapcast_data, include.column.names=TRUE)
}
