\name{REAT-package}
\alias{REAT-package}
\alias{REAT}
\docType{package}
\title{
Regional Economic Analysis Toolbox
}

\description{
In regional and urban economics and economic geography, very frequent research fields are the existence and evolution of agglomerations due to (internal and external) agglomeration economies, regional economic growth and regional disparities, where these concepts and relationships are closely related to each other (Capello/Nijkamp 2009, Dinc 2015, Farhauer/Kroell 2013, McCann/van Oort 2009). Also accessibility and spatial interaction modeling is mostly regarded as related to these disciplines (Aoyama et al. 2011, Guessefeldt 1999). The group of the related analysis methods is sometimes summarized by the term \emph{regional analysis} or \emph{regional economic analysis} (Dinc 2015, Guessefeldt 1999, Isard 1960). 

This package contains a collection of models and analysis methods used in regional and urban economics and (quantitative) economic geography. The functions in this package can be divided into seven groups: 

(1) Inequality, concentration and dispersion, including \emph{Gini coefficient}, \emph{Lorenz curve}, \emph{Herfindahl-Hirschman-coefficient}, \emph{Theil coefficient}, \emph{Hoover coefficient} and \emph{(weighted) coefficient of variation}

(2) Specialization of regions and spatial concentration of industries, including \emph{location quotient}, \emph{spatial Gini coefficients} for regional specialization and industry concentration and \emph{Krugman coefficients} for regional specialization and industry concentration

(3) Regional disparities and regional convergence, especially analysis of \emph{beta and sigma convergence} for cross-sectional data

(4) Regional growth, including \emph{portfolio matrix}, several types of \emph{shift-share analysis} and \emph{commercial area prognosis} ("GIFPRO")

(5) Spatial interaction and accessibility models, including \emph{Huff model} and \emph{Hansen accessibility}

(6) Proximity analysis, including calculation of \emph{distance matrices} and \emph{buffers} 

(7) Additional tools for data preparation und visualization, such as for creating \emph{dummy variables} and calculating \emph{standardized regression coefficients}. 
The package also contains data examples. 
}

\author{
Thomas Wieland

Maintainer: Thomas Wieland \email{thomas.wieland.geo@googlemail.com}
}

\references{
Aoyama, Y./Murphy, J. T./Hanson, S. (2011): \dQuote{Key Concepts in Economic Geography}. London: SAGE.

Capello, R./Nijkamp, P. (2009): \dQuote{Introduction: regional growth and development theories in the twenty-first century - recent theoretical advances and future challenges}. In: Capello, R./Nijkamp, P. (eds.): \emph{Handbook of Regional Growth and Development Theories}. Cheltenham: Elgar. p. 1-16.

Dinc, M. (2015): \dQuote{Introduction to Regional Economic Development. Major Theories and Basic Analytical Tools}. Cheltenham: Elgar. 

Farhauer, O./Kroell, A. (2013): \dQuote{Standorttheorien: Regional- und Stadtoekonomik in Theorie und Praxis}. Wiesbaden: Springer.

Guessefeldt, J. (1999): \dQuote{Regionalanalyse}. Muenchen: Oldenbourg.

Isard, W. (1960): \dQuote{Methods of Regional Analysis: an Introduction to Regional Science}. Cambridge: M.I.T. Press.

McCann, P./van Oort, F. (2009): \dQuote{Theories of agglomeration and regional economic growth: a historical review}. In: Capello, R./Nijkamp, P. (eds.): \emph{Handbook of Regional Growth and Development Theories}. Cheltenham: Elgar. p. 19-32.
}