% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds.data.frame-plots.R
\name{reingold.tilford.plot}
\alias{reingold.tilford.plot}
\title{Plots the recruitment network using the Reingold Tilford algorithm.}
\usage{
reingold.tilford.plot(
  x,
  vertex.color = NULL,
  vertex.color.scale = hue_pal(),
  vertex.size = 2,
  vertex.size.range = c(1, 5),
  edge.arrow.size = 0,
  vertex.label.cex = 0.2,
  vertex.frame.color = NA,
  vertex.label = get.id(x),
  show.legend = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{An rds.data.frame}

\item{vertex.color}{The name of the categorical variable in x to color the points with.}

\item{vertex.color.scale}{The scale to create the color palette.}

\item{vertex.size}{The size of the vertex points. either a number or the name of a 
column of x.}

\item{vertex.size.range}{If vertex.size represents a variable, vertex.size.range is a 
vector of length 2 representing the minimum and maximum cex for the points.}

\item{edge.arrow.size}{The size of the arrow from recruiter to recruitee.}

\item{vertex.label.cex}{The size expansion factor for the vertex.labels.}

\item{vertex.frame.color}{the color of the outside of the vertex.points.}

\item{vertex.label}{The name of a variable to use as vertex labels. NA implies no labels.}

\item{show.legend}{If true and either vertex.color or vertex.size represent variables, 
legends will be displayed at the bottom of the plot.}

\item{plot}{Logical, if TRUE then a plot is produced of recruitment tree.
ratio statistic with the observed statistics plotted as a vertical dashed line.}

\item{...}{Additional parameters passed to plot.igraph.}
}
\value{
A two-column vector of the positions of the nodes in the recruitment tree.
}
\description{
Plots the recruitment network using the Reingold Tilford algorithm.
}
\examples{
\dontrun{
data(fauxmadrona)
data(faux)
reingold.tilford.plot(faux)
reingold.tilford.plot(fauxmadrona,vertex.color="disease")
}
}
