% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiPhaseTimeRange}
\alias{MultiPhaseTimeRange}
\title{Phase Time Range for multiple phases}
\usage{
MultiPhaseTimeRange(file, position, level = 0.95, max_decimal = 0,
dec = '.', sep=',', comment.char='#')
}
\arguments{
  \item{file}{name of the CSV file containing the output of the MCMC algorithm of all pahses of interest}
  \item{position}{numeric vector containing the position of the beginning of the phases of interest in the CSV file}
  \item{level}{probability corresponding to the desired level of confidence}
  \item{max_decimal}{maximum number of decimal}
  \item{dec}{the character used in the file for decimal points for the use of read.csv()}
  \item{sep}{the field separator character for the use of read.csv()}
  \item{comment.char}{a character vector of length one containing a single character or an empty string for the use of read.csv()}
}
\value{
Returns a matrix of values containing the level of confidence and the endpoints of the shortest time range associated with the desired level
}
\description{
Computes the shortest interval that satisfies : P(Phase1End < IntervalInf < IntervalSup < Phase2Beginning | M) = level
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Phases)
  write.csv(Phases, "data.csv")
  MultiPhaseTimeRange("data.csv", c(4,2), 0.95, 0)
}
\keyword{ phase time range }
