% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{add_metrics}
\alias{add_metrics}
\title{Adds several metrics to df_results.}
\usage{
add_metrics(
  df_results,
  index_configuration,
  pic_sigma2,
  beta_est,
  g,
  comfactor,
  lambda,
  factor_group,
  lambda_group,
  iteration,
  g_true = NA,
  add_rand = FALSE
)
}
\arguments{
\item{df_results}{dataframe with results for each estimated configuration}

\item{index_configuration}{index of the configuration of groups and factors}

\item{pic_sigma2}{sum of squared errors divided by NT}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with estimated group membership for all individuals}

\item{comfactor}{estimated common factors}

\item{lambda}{loadings of the estimated common factors}

\item{factor_group}{estimated group specific factors}

\item{lambda_group}{loadings of the estimated group specific factors}

\item{iteration}{number of iteration}

\item{g_true}{vector of length NN with true group memberships}

\item{add_rand}{adds the adjusted randindex to the df (requires the mclust package); used for simulations}
}
\value{
data.frame with final estimations of each configuration
}
\description{
Adds several metrics to df_results.
}
\examples{
df_results <- add_configuration(initialise_df_results(TRUE),
  3, 0, c(3, 3, 3, rep(NA, 17))) #data.frame with one configuration
add_metrics(df_results, 1, 3.94, NA, round(runif(30, 1, 3)), NA, NA, NA, NA, 9)
}
