% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{define_kg_candidates}
\alias{define_kg_candidates}
\title{Defines the set of combinations of group specific factors.}
\usage{
define_kg_candidates(S, kg_min, kg_max, nfv = TRUE, limit_est_groups = 20)
}
\arguments{
\item{S}{number of estimated groups}

\item{kg_min}{minimum value for number of group specific factors}

\item{kg_max}{minimum value for number of group specific factors}

\item{nfv}{logical; whether the number of group specific factors is allowed to change among the groups}

\item{limit_est_groups}{maximum allowed number of groups that can be estimated}
}
\value{
Returns a data frame where each row contains the number of group specific factors for all the estimated groups.
The number of columns is set to 20 (the current maximum amount of group that can be estimated)
}
\description{
Defines the set of combinations of group specific factors.
}
\examples{
define_kg_candidates(3, 2, 4)
}
