% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printC.r
\name{printC}
\alias{printC}
\title{Prints table of results to a .html file in local working directory}
\usage{
printC(objx, file)
}
\arguments{
\item{objx}{A table or data frame. The table must be html-ready, not all Console output is organized in tables. If objx is not a html-ready table, \code{printC} will write it as preformatted text to the .html file in the working directory.}

\item{file}{(Optional) The path/file name for .html output. If not specified, function will output to .html file in your working directory.}
}
\value{
No return to R. The formatted objx is outputted to a .html file in working directory.
}
\description{
Prints table or summary of results to a .html file in local working directory. Converting Console format tables to .html tables helps users quickly create publication- and presentation-ready tables. The .html file's name is displayed as Console message.
Current date added to Table.Output.html file name to keep output organized. You can print output directly from Companion functions using \code{printC=TRUE} argument (where available).
}
\section{Textbook Reference}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 1.
}
}

\examples{
   library(RCPA3)
   
   example.table <- freqC(x=world$vdem.4cat, plot=FALSE)
   # running printC will generate a .html file in your working directory
\donttest{
   printC(example.table, file=tempfile(fileext = ".html"))
}
}
