% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NICERd.R
\name{NICERd}
\alias{NICERd}
\title{New (Accelerated) Incremental Cell Enumeration (in) R}
\usage{
NICERd(
  A,
  b,
  initial = rep(0, ncol(A)),
  verb = TRUE,
  accelerate = FALSE,
  epsbound = 1,
  epstol = 1e-07
)
}
\arguments{
\item{A}{is a n by d matrix of hyperplane slope coefficients}

\item{b}{is an n vector of hyperplane intercept coefficients}

\item{initial}{origin for the interior point vectors \code{w}}

\item{verb}{controls verbosity of Mosek solution}

\item{accelerate}{allows the option to turn off acceleration step (turned off by default)}

\item{epsbound}{is a scalar tolerance controlling how close the witness point
can be to an edge of the polytope}

\item{epstol}{is a scalar tolerance for the LP convergence}
}
\value{
A list with components:
\itemize{
\item  SignVector a n by m matrix of signs determining position of cell relative 
	to each hyperplane.
\item  w a d by m matrix of interior points for the m cells
}
}
\description{
Find interior points and cell counts of the polygons (polytopes) formed by a
hyperplane arrangement.
}
\details{
Modified version of the algorithm of Rada and Cerny (2018).
The main modifications include preprocessing as hyperplanes are added
to determine which new cells are created, thereby reducing the number of
calls to the witness function to solve LPs, and treatment of degenerate
configurations as well as those in "general position." (for \eqn{d=2} for now).  When the hyperplanes
are in general position the number of cells (polytopes) is determined by the
elegant formula of Zaslavsky (1975) \deqn{m = {n \choose d} + n + 1}.  In
degenerate cases, i.e. when hyperplanes are not in general position, the
number of cells is more complicated as considered by Alexanderson and Wetzel (1981).
The function \code{polycount} is provided to check agreement with their results
in an effort to aid in the selection of tolerances for the \code{witness} function for arrangement in \eqn{d=2}.
The current version is intended mainly for use with \eqn{d = 2}, but the algorithm is adapted to
the general position setting with \eqn{d > 2}, although it requires hyperplanes in general position and may require some patience when both
the sample size is large.
if hyperplanes not general position (i.e. all cross at origin), turn off accelerate
}
\references{
Alexanderson, G.L and J.E. Wetzel, (1981) Arrangements of planes in space, 
Discrete Math, 34, 219--240.
Rada, M. and M. Cerny (2018) A new algorithm for the enumeration of cells 
of hyperplane arrangements and a comparison with Avis and Fukada's reverse 
search, SIAM J. of Discrete Math, 32, 455-473.
Zaslavsky, T. (1975) Facing up to arrangements:  Face-Count Formulas for 
Partitions of Space by Hyperplanes, Memoirs of the AMS, Number 154.
}
