% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/UserMetrics.R
\name{user_Metrics_ReferringDomains}
\alias{user_Metrics_ReferringDomains}
\title{Returns aggregate metrics about the domains referring click traffic to all of the authenticated user's Bitlinks.}
\usage{
user_Metrics_ReferringDomains(limit = 1000, unit = c("minute", "hour",
  "day", "week", "month"), rollup = c("false", "true"), units = -1,
  login = NULL, exclude_social_networks = c("true", "false"),
  showRequestURL = FALSE)
}
\arguments{
\item{limit}{- 1 to 1000 (default=1000).}

\item{unit}{- minute, hour, day, week or month, default: day; Note: when unit is minute the maximum
value for units is 60.}

\item{rollup}{- true or false. Return data for multiple units rolled up to a single result instead
of a separate value for each period of time.}

\item{units}{- an integer representing the time units to query data for. Pass -1 to return all
units of time.}

\item{login}{- an optional string consisting of the account name used to report the appropriate
statistics; defaults to the current user.}

\item{exclude_social_networks}{- true (default) or false. If true, exclude domains that are
part of a social network that bitly tracks.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
clicks - the number of clicks referred from this URL.

referrer - the URL referring clicks.
}
\description{
If the user is a master (ent.) account, or is a subaccount with full_reports permission, the
user may choose to view the metrics of any account belonging to the master account.
}
\note{
When a unit is specified (always the case), rollup is always (!) true.
}
\examples{
rbitlyApi("0906523ec6a8c78b33f9310e84e7a5c81e500909")
user_Metrics_ReferringDomains(unit = "day", units = -1, limit = 100, rollup = "true")
user_Metrics_ReferringDomains(unit = "day", units = -1, limit = 100, rollup = "false")
user_Metrics_ReferringDomains(unit = "day", units = -1, limit = 100,
exclude_social_networks = "false")
user_Metrics_ReferringDomains(unit = "day", units = -1, limit = 100,
exclude_social_networks = "true")
}
\seealso{
See \url{http://dev.bitly.com/user_metrics.html#v3_user_referring_domains}
}

