% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSpreadsheet.R
\name{readSpreadsheet}
\alias{readSpreadsheet}
\title{Read a Downloaded Spreadsheet}
\usage{
readSpreadsheet(
  destfile,
  series,
  subFileName,
  fieldForColumnNames,
  deleteFiles
)
}
\arguments{
\item{destfile}{File path of the downloaded spreadsheet.}

\item{series}{Character string giving the name of the data series to retrieve.}

\item{subFileName}{Name of the spreadsheet for download according to the source
URL.}

\item{fieldForColumnNames}{If replaceColumnNames is TRUE then this variable
specifies which columns of the meta data file will be
used to construct the column names.  Defaults to
\dQuote{Series} but sometimes you may want to change
it to \dQuote{Group} or c(\dQuote{Group},
\dQuote{Series}).  \dQuote{SeriesID} is also allowed.}

\item{deleteFiles}{Logical indicating whether to delete the spreadsheet after
reading it.}
}
\value{
The contents of the spreadsheet. For most series this will be in the
        form of a list of two data frames, one called \dQuote{data} and the
        other \dQuote{meta}. For some series (see specialCases()), the data
        is not in the standard format as the rest and so is just returned
        directly as the results of read_xlsx for each sheet in the spreadsheet.
}
\description{
Read a Downloaded Spreadsheet
}
\note{
Series B13 doesn't have a full date specified, only year or month and
      year. These values values are returned as the first of the month/year.
}
\author{
Jasper Watson
}
\keyword{internal}
