% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBF-fn.R
\name{psi.huber}
\alias{psi.huber}
\title{Derivative of Huber's loss function.}
\usage{
psi.huber(r, k = 1.345)
}
\arguments{
\item{r}{a vector of real numbers}

\item{k}{a positive tuning constant.}
}
\value{
A vector of the same length as \code{x}.
}
\description{
This function evaluates the first derivative of Huber's loss function.
}
\details{
This function evaluates the first derivative of Huber's loss function.
}
\examples{
x <- seq(-2, 2, length=10)
psi.huber(r=x, k = 1.5)

}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}, Alejandra Martinez
}
