% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PT.Khmaladze.MultTest.R
\name{PT.Khmaladze.MultTest}
\alias{PT.Khmaladze.MultTest}
\title{Martingale transformed Permutation Test: Multiple Testing procedures.}
\usage{
PT.Khmaladze.MultTest(data, procedure = "maxT", alpha = 0.05,
  n.perm = 499, B = 499, na.action)
}
\arguments{
\item{data}{List. Data are presented in the form of a list, where each sublist contains the treatment and control group observations for a specific subgroup.}

\item{procedure}{multiple testing procedure. Several options are available, including maxT and minP (Westfall and Young (1993)), Bonferroni adjustment, and Holm (1979) procedure. The default is Bonferroni.}

\item{alpha}{Significance level.}

\item{n.perm}{Numeric. Number of permutations needed for the stochastic approximation of the p-values. See Remark 4 in Chung and Olivares (2019). The default is n.perm=499.}

\item{B}{Numeric. Number of permutations needed for the stochastic approximation in the Westfall-Young procedures. See Remark 11 in Chung and Olivares (2019). The default is B=499.}

\item{na.action}{a function to filter missing data. This is applied to the model.frame . The default is na.omit, which deletes observations that contain one or more missing values.}
}
\value{
An object of class "PT.Khmaladze.MultTest" is a list containing at least the following components:
 \item{description}{Type of multiple testing adjustment. It can be Westfall-Young's maxT, minP, Holm or Bonferroni.}
 \item{n.subgroups}{Number of subgrups for a specific covariate.}
 \item{T.obs}{Vector. Observed test statistic for each subgroup.}
 \item{pvalues}{Vector. P-value for each individual test.}
 \item{adj.pvalue}{Vector. Adjusted p-values according to the user-chosen multiple testing procedure.}
 \item{n.perm}{Number of permutations.}
 \item{B}{Number of permutations used in the Westfall-Young procedure.}
 \item{sample.sizes}{Subgroup sample sizes.}
 \item{alpha}{Significance level.}
}
\description{
This function applies the martingale transformed Permutation test (Chung and Olivares (2019)) to test whether there exists within-group treatment effect heterogeneity. 
The method jointly tests the null hypotheses that treatment effects are constant within mutually exclusive subgroups while allowing them to be different across subgroups. More formally, 
assume the mutually exclusive subgroups are formed from observed covariates, and are taken as given. Denote \eqn{\mathcal{J}} the total number of such subgroups. 
Let \eqn{F_0^{j}(y)} and \eqn{F_1^{j}(y)} be the CDFs of the control and treatment group for subgroup \eqn{1\le j\le \mathcal{J}}. The null hypothesis of interest is given by the joint hypothesis
\deqn{\mathbf{H}_{0}: F_1^{j}(y + \delta_{j}) = F_0^{j}(y)}
for all mutually exclusive \eqn{j\in\{1,\dots,\mathcal{J}\}}, for some \eqn{\delta_j}. We are treating \eqn{\mathbf{H}_0} as a multiple testing problem in which every individual hypothesis \eqn{j\in\{1,\dots,\mathcal{J}\}}, given by
\deqn{H_{0,j}: F_1^{j}(y + \delta_{j}) = F_0^{j}(y)}
for some \eqn{\delta_j} specifies whether the treatment effect is heterogeneous for a particular subgroup.

To achieve control of the family-wise error rate, the function considers several multiple testing procedures, such as Bonferroni, maxT and minP (Westfall and Young (1993)), and Holm (1979).
For further details, see Chung and Olivares (2019).
}
\examples{
\dontrun{
subgroup1 <- list()
subgroup1$Y0 <- rnorm(11)
subgrpup1$Y1 <- rnorm(8,1,1) 
subgroup2 <- list()
subgroup2$Y0 <- rnorm(9)
subgroup2$Y1 <- rnorm(7,1,2)
data <- list(subgroup1,subgroup2)
res.minP <- PT.Khmaladze.MultTest(data,"minP",n.perm=100,B=100)
summary(res.minP)
adjusted.p.values <- res.minP$adj.pvalues
adjusted.p.values
}
}
\references{
Chung, E. and Olivares, M. (2019). Permutation Test for Heterogeneous Treatment Effects with a Nuisance Parameter. Working Paper.
Holm, S. (1979). A simple sequentially rejective multiple test procedure. Scandinavian Journal of Statistics, pages 65-70.
Westfall, P.H. and Young, S.S. (1993). Resampling-based multiple testing: Examples and methods for p-value adjustment, Volume 279, John & Wiley Sons.
}
\author{
Maurcio Olivares
}
\keyword{Khmaladze}
\keyword{Multiple}
\keyword{Permutation}
\keyword{Test}
\keyword{Testing}
\keyword{Westfall-Young}
