% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmax_NIX.r
\name{pmax_NIX}
\alias{pmax_NIX}
\title{Posterior Probability that a Particular Arm is the Best for Continuous Endpoint with Unknown Variances}
\usage{
pmax_NIX(
  armn,
  par1 = NULL,
  par2 = NULL,
  par3 = NULL,
  par4 = NULL,
  par5 = NULL,
  side,
  ...
)
}
\arguments{
\item{armn}{number of arms in the trial with values up to 5. When \code{armn}=2,
only \code{par1} to \code{par2} need to be specified.
When \code{par1} to \code{par3} need to be specified.
When \code{par1} to \code{par4} need to be specified.
When \code{par1} to \code{par5} need to be specified.}

\item{par1}{a vector of parameters including m, V, a, b for the arm with a Normal-Inverse-Chi-Squared prior
to calculate the allocation probability of.}

\item{par2}{a vector of parameters including m, V, a, b for one of the remaining arms with a Normal-Inverse-Chi-Squared prior.}

\item{par3}{a vector of parameters including m, V, a, b for one of the remaining arms with a Normal-Inverse-Chi-Squared prior.}

\item{par4}{a vector of parameters including m, V, a, b for one of the remaining arms with a Normal-Inverse-Chi-Squared prior.}

\item{par5}{a vector of parameters including m, V, a, b for one of the remaining arms with a Normal-Inverse-Chi-Squared prior.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}

\item{...}{additional arguments to be passed to \code{\link[stats]{integrate}} (such as rel.tol) from this function.}
}
\value{
a probability that a particular arm is the best in trials up to five arms.
}
\description{
Calculate posterior probability that a particular arm is the best in a trial using Bayesian response-adaptive randomization with
a control group (the Thall \eqn{\&} Wathen method). The conjugate prior distributions follow Normal-Inverse-Chi-Squared (NIX)
distributions for continuous outcomes with unknown variance in each arm and can be specified individually.
}
\details{
This function calculates the results of formula \eqn{Pr(\mu_k=max\{\mu_1,...,\mu_k\})} for
\code{side} equals to 'upper' and the results of formula \eqn{Pr(\mu_k=min\{\mu_1,...,\mu_k\})} for
\code{side} equals to 'lower'. This function returns the probability that the posterior probability of arm
\eqn{k} is maximal or minimal in trials with up to five arms. Parameters used in a Normal-Inverse-Gamma 
(\eqn{(\mu,\sigma^2) \sim NIG(mean=m,variance=V \times \sigma^2,shape=a,rate=b)})
distribution should be converted to parameters equivalent in a Normal-Inverse-Chi-Squared
(\eqn{(\mu,\sigma^2) \sim NIX(mean=\mu,effective sample size=\kappa,degrees of freedom=\nu,variance=\sigma^2/\kappa)})
distribution using \code{convert_gamma_to_chisq} before applying this function.
}
\examples{
para<-list(V=1/2,a=0.8,m=9.1,b=1/2)
par<-convert_gamma_to_chisq(para)
set.seed(123451)
y1<-rnorm(100,9.1,1)
par11<-update_par_nichisq(y1, par)
set.seed(123452)
y2<-rnorm(90,9,1)
par22<-update_par_nichisq(y2, par)
set.seed(123453)
y3<-rnorm(110,8.92,1)
par33<-update_par_nichisq(y3, par)
y4<-rnorm(120,8.82,1)
par44<-update_par_nichisq(4, par)
pmax_NIX(armn=4,par1=par11,par2=par22,par3=par33,par4=par44,side='upper')
pmax_NIX(armn=4,par1=par11,par2=par22,par3=par33,par4=par44,side='lower')

para<-list(V=1/2,a=0.5,m=9.1/100,b=0.00002)
par<-convert_gamma_to_chisq(para)
set.seed(123451)
y1<-rnorm(100,0.091,0.009)
par11<-update_par_nichisq(y1, par)
set.seed(123452)
y2<-rnorm(90,0.09,0.009)
par22<-update_par_nichisq(y2, par)
set.seed(123453)
y3<-rnorm(110,0.0892,0.009)
par33<-update_par_nichisq(y3, par)
pmax_NIX(armn=3,par1=par11,par2=par22,par3=par33,side='upper')
pmax_NIX(armn=3,par1=par11,par2=par22,par3=par33,side='lower')
}
