\name{svg2swf}
\alias{svg2swf}
\title{Convert a sequence of SVG files to SWF file}
\usage{
svg2swf(filenames, outdir = getwd(), output = "movie.swf", 
    interval = 1)
}
\arguments{
  \item{filenames}{the file names of the SVG files to be
  converted.}

  \item{outdir}{the output directory}

  \item{output}{the name of the output swf file.}

  \item{interval}{the time interval between animation
  frames.}
}
\value{
  The path of the generated swf file if successful.
}
\description{
  Given the file names of a sequence of SVG file, this
  function could convert them into a Flash file (.swf).
}
\details{
  This function uses the XML package in R and a subset of
  librsvg (\url{http://librsvg.sourceforge.net/}) to parse
  the SVG file, and utilize the Ming library
  (\url{http://www.libming.org/}) to implement the
  conversion. Currently the support for SVG file is
  \strong{NOT} perfect and \strong{ONLY} support files
  generated by \code{\link[Cairo]{CairoSVG}()} in the
  \pkg{Cairo} package.
}
\note{
  Currently there is no function in R that could
  auto-generate a sequence of SVG file, so you may create
  the SVG file once at a time. See the example.
}
\examples{
if (require("Cairo")) {
    filenames = sprintf("Rplot\%03d.svg", 1:9)
    for (fn in filenames) {
        CairoSVG(fn)
        plot(runif(20), ylim = c(0, 1))
        dev.off()
    }
    output = svg2swf(filenames)
    swf2html(output)
}
}
\author{
  Yixuan Qiu <\email{yixuan.qiu@cos.name}>
}
