%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  
% 
% on Tue Feb 15 13:44:23 2005.
% 
% Generator was the Rdoc class, which is part of the R.oo package written
% by Henrik Bengtsson, 2001-2004.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{setMethodS3}
\alias{setMethodS3.default}
\alias{setMethodS3}

\title{Creates a method for a class using S3/UseMethod style}

\description{
 Creates a method for a class using S3/UseMethod style. A function with
 name \code{name.class} will be set to \code{definition}. The method
 will get the modifiers specified by \code{modifiers}.
 If there exists no generic function for this method, it will be
 created automatically.
}

\usage{\method{setMethodS3}{default}(name, class="default", definition, private=FALSE, protected=FALSE, static=FALSE, abstract=FALSE, trial=FALSE, deprecated=FALSE, envir=parent.frame(), overwrite=TRUE, conflict=c("warning", "error", "quiet"), createGeneric=TRUE, appendVarArgs=TRUE, enforceRCC=TRUE, ...)}

\arguments{
  \item{name}{The name of the method.}
  \item{class}{The class for which the method should be defined. If
     \code{class == "default"} (or \code{class == "ANY"}) a function
     with name \code{name.default} will be created.}
  \item{definition}{The method defintion.}
  \item{private, protected}{If \code{private=TRUE}, the method is declared
     private. If \code{protected=TRUE}, the method is declared protected.
     In all other cases the method is declared public.}
  \item{static}{If \code{\link[base:logical]{TRUE}} this method is defined to be static,
     otherwise not. Currently this has no effect expect as an indicator.}
  \item{abstract}{If \code{\link[base:logical]{TRUE}} this method is defined to be abstract,
     otherwise not. Currently this has no effect expect as an indicator.}
  \item{trial}{If \code{\link[base:logical]{TRUE}} this method is defined to be a trial method,
     otherwise not. A trial method is a method that is introduced to be
     tried out and it might be modified, replaced or even removed in a
     future release. Some people prefer to call trial versions, beta
     version. Currently this has no effect expect as an indicator.}
  \item{deprecated}{If \code{\link[base:logical]{TRUE}} this method is defined to be deprecated,
     otherwise not. Currently this has no effect expect as an indicator.}
  \item{envir}{The environment for where this method should be stored.}
  \item{overwrite}{If \code{\link[base:logical]{TRUE}} an already existing method with the same
     name (and of the same class) will be overwritten, otherwise not.}
  \item{conflict}{If a method already exists with the same name (and of
     the same class), different actions can be taken. If \code{"error"},
     an exception will be thrown and the method will not be created.
     If \code{"warning"}, a \code{\link[base]{warning}} will be given and the method \emph{will}
     be created, otherwise the conflict will be passed unnotice.}
  \item{createGeneric}{If \code{\link[base:logical]{TRUE}}, a generic S3/UseMethod function is
     defined for this method.}
  \item{enforceRCC}{If \code{\link[base:logical]{TRUE}}, only class names following the R Coding
     Convention is accepted. If the RCC is violated an RccViolationException
     is thrown.}
  \item{appendVarArgs}{If \code{\link[base:logical]{TRUE}}, argument \code{...} is added with a
     warning, if missing.  For special methods such as \code{$} and
     \code{[[}, this is never done.
     This will increase the chances that the method is consistent with a
     generic function with many arguments and/or argument \code{...}.}
  \item{...}{Not used.}
}

\examples{
 ######################################################################
# Example 1
######################################################################
setMethodS3("foo", "default", function(x, ...) {
  cat("In default foo():\n");
  print(x, ...);
})


setMethodS3("foo", "character", function(s, ...) {
  cat("In foo() for class 'character':\n");
  print(s, ...);
})

# The generic function is automatically created!
print(foo)

foo(123)
foo("123")


######################################################################
# Example 2
#
# Assume that in a loaded package there is already a function bar(),
# but you also want to use the name 'bar' for the character string.
# It may even be the case that you do not know of the other package,
# but your users do!
######################################################################
# bar() in other package
bar <- function(x, y, ...) {
  cat("In bar() of 'other' package.\n");
}


# Your defintion; will redefine bar() above to bar.default().
setMethodS3("bar", "character", function(object, ...) {
  cat("In bar() for class 'character':\n");
  print(object, ...);
})

bar(123)
bar("123")




 \dontrun{For a complete example see help(Object).}
}

\seealso{
  To define a class, see \code{\link{setConstructorS3}}().
  For a thorough example of how to use this method see \code{\link{Object}}.
  For information about the R Coding Conventions, see
  \code{\link{RccViolationException}}.
  For more information about \code{UseMethod()} see \code{\link[base]{methods}}.
}

\author{Henrik Bengtsson \url{http://www.braju.com/R/}}

\keyword{programming}
\keyword{methods}
