% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.Q.R
\name{sim.Q}
\alias{sim.Q}
\title{generate a random Q-matrix}
\usage{
sim.Q(K, I)
}
\arguments{
\item{K}{The number of attributes of each item.}

\item{I}{The number of items.}
}
\value{
An object of class \eqn{matrix}.
}
\description{
generate a \eqn{I} * \eqn{K} Q-matrix randomly, which consisted of one-attribute q-vectors
(0.5), two-attribute q-vectors (0.25), and three-attribute q-vectors (0.25). 
This function ensures that the generated Q-matrix contains at least two identity matrices as a priority.
}
\examples{
library(Qval)

set.seed(123)

Q <- sim.Q(5, 10)
print(Q)

}
\references{
Najera, P., Sorrel, M. A., de la Torre, J., & Abad, F. J. (2021). Balancing fit and parsimony to improve Q-matrix validation. Br J Math Stat Psychol, 74 Suppl 1, 110-130. DOI: 10.1111/bmsp.12228.
}
\author{
Haijiang Qin <Haijiang133@outlook.com>
}
