% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald.test.R
\name{Wald.test}
\alias{Wald.test}
\title{Wald.test for two q-vecotrs}
\usage{
Wald.test(CDM.obj, Q.i, Q.i.k, i = 1)
}
\arguments{
\item{CDM.obj}{An object of class \code{CDM.obj}. @seealso \code{\link[Qval]{CDM}}.}

\item{Q.i}{A q-vector}

\item{Q.i.k}{Another q-vector}

\item{i}{the item you focusing on}
}
\value{
An object of class \code{list} containing the following components:
\item{Wald.statistic}{The statistic of the Wald test.}
\item{p.value}{The p value}
}
\description{
This function flexibly provides the Wald test for any two q-vectors of a given item in the Q-matrix, 
but requires that the two q-vectors differ by only one attribute. Additionally, this function needs 
to accept a \code{CDM.obj}.
}
\details{
\deqn{
   Wald = (\mathbf{R} \times P_{i}(\mathbf{\alpha}))^{'}
   (\mathbf{R} \times \mathbf{V}_{i} \times \mathbf{R})^{-1}
   (\mathbf{R} \times P_{i}(\mathbf{\alpha}))
}
}
\examples{

set.seed(123)

K <- 3
I <- 20
N <- 500
IQ <- list(
  P0 = runif(I, 0.0, 0.2),
  P1 = runif(I, 0.8, 1.0)
)
Q <- sim.Q(K, I)
data <- sim.data(Q = Q, N = N, IQ = IQ, model = "GDINA", distribute = "horder")

CDM.obj <- CDM(data$dat, Q)

Q.i <- c(1, 0, 0)
Q.i.k <- c(1, 1, 0)

## Discuss whether there is a significant difference when 
## the q-vector of the 2nd item in the Q-matrix is Q.i or Q.i.k.
Wald.test.obj <- Wald.test(CDM.obj, Q.i, Q.i.k, i=2)

print(Wald.test.obj)


}
