% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbrNBglm.R
\name{fbrNBglm}
\alias{fbrNBglm}
\alias{fbrNBglm.fit}
\alias{fbrNBglm.control}
\title{Firth-Type Bias-Reduced Negative Binomial Log-Linear Model}
\usage{
fbrNBglm.fit(x, y, weights = rep(1, length(y)), offset = rep(0, length(y)),
  family, odisp, control = fbrNBglm.control())

fbrNBglm.control(standardizeX = TRUE, coefOnly = TRUE,
  solvers = nlSolvers, verbose = FALSE, maxit = 25L, start = NULL,
  infoParms = list(j = 1, k = 1, m = 1), order = 2L,
  tol = sqrt(.Machine$double.eps), qr.tol = tol)
}
\arguments{
\item{x, y, weights, offset}{Defined the same as in \code{\link{glm.fit}}.}

\item{family}{The same as in \code{\link{glm.fit}}, but the default 
(and the only currently supported) choice is \code{negbin{'log', odisp}}, 
where \code{odisp} is defined below.}

\item{odisp}{A numeric scalar of negative binomial over-dispersion parameter. 
This is the same as \code{1/size}, where \code{size} is the parameter 
as in \code{\link{dnbinom}}.}

\item{control}{A list returned from \code{fbrNBglm.control}.}

\item{standardizeX}{A logical scalar. If \code{TRUE}, columns of 
design matrix will be standardized with norm 1 during the 
fitting process, except for columns with identical values.}

\item{coefOnly}{A logical scalar. If \code{TRUE}, only the regression
coefficients will be returned. This is useful when being called
from other functions, e.g. \code{\link{NBDev}}. If \code{coef=FALSE},
a \code{glm} object will be returned.}

\item{solvers}{The non-linear equation solvers to be used if iterative 
fitting is necessary.}

\item{verbose}{A logical scalar, indicating whether intermediate messages 
should be printed.}

\item{maxit}{A positive integer, the maximum number of iterations allowed
if iterative fitting is necessary.}

\item{start}{A numeric vector of starting values, with length being the
same as the number of columns of \code{x}.}

\item{infoParms}{A list of three components, named \code{j}, \code{k}, 
and \code{m}, respectively. These parameters control the type of 
adjustment made to the score function. When all j, k, and m are 1, 
the observed information is used in the adjustment. When \code{k=0},
the expected information is used. See reference for details.}

\item{order}{A positive integer. Usually this should be set to 2, 
indicating the second order, i.e., \eqn{O(n^{-1})}{O(n^{-1})} bias 
being reduced by the adjustment. For one-way design, if \code{infoParms$j=1} and offsets are constants within each treatment, the third
order bias reduction with \code{order=3} is also support, resulting 
in an estimate with both \eqn{O(n^{-1})}{O(n^{-1})} order and 
\eqn{O(n^{-2})}{O(n^{-2})} order biases being reduced.}

\item{tol}{Small positive integer, indicating the desired accuracy
of parameter estimates.}

\item{qr.tol}{The same as the \code{tol} argument of \link[base:qr]{qr}.}
}
\value{
It depends.
}
\description{
This is the estimation algorithm for generalized linear model with negative binomial responses
and log link function. Sore functions are modified properly such that 
bias in the coefficients are reduced.
}
\examples{
 ## prepare example data
 data(mockRNASeqData)
 x=mockRNASeqData$design.matrix
 y=mockRNASeqData$counts[3462,]
 offset = log(mockRNASeqData$estimated.normalization)
 overDisp = mockRNASeqData$estimated.nbdisp[3462]
 nbfam = negbin('log', overDisp)
 
 ## usual maximum likelihood estimate
 coef(glm.fit(x, y, offset=offset, family=nbfam))
 
 ## 2nd-order biased reduced fit with observed information
 ctrl= fbrNBglm.control(infoParms=list(j=1,k=1,m=1), order=2L, coefOnly=TRUE)
 fbrNBglm.fit(x, y, offset=offset, family=nbfam, control=ctrl)

 ## 2nd-order biased reduced fit with expected information
 ctrl= fbrNBglm.control(infoParms=list(j=0,k=1,m=1), order=2L, coefOnly=TRUE)
 fbrNBglm.fit(x, y, offset=offset, family=nbfam, control=ctrl)
 
 ## 3rd-order biased reduced fit with observed information
 ## Not available yet if offsets are non-constants with a treatment
 offset.avg = ave(offset, mockRNASeqData$treatment)
 ctrl= fbrNBglm.control(infoParms=list(j=1,k=1,m=1), order=3L, coefOnly=TRUE)
 fbrNBglm.fit(x, y, offset=offset.avg, family=nbfam, control=ctrl)

}
\author{
Long Qu <rtistician@gmail.com>
}
\concept{Firth bias reduction}
\keyword{iteration}
\keyword{models}
\keyword{regression}
