% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetDistance.R
\name{AllQuartets}
\alias{AllQuartets}
\title{List all quartets}
\usage{
AllQuartets(n_tips)
}
\arguments{
\item{n_tips}{Integer, specifying the number of tips in a tree.}
}
\value{
Returns a list of length \code{choose(n_tips, 4)}, with each entry
corresponding to a unique selection of four different integers less than
or equal to \code{n_tips}
}
\description{
Lists all choices of four taxa from a tree.

A more computationally efficient alternative to \code{\link[utils]{combn}},
\code{AllQuartets} uses \code{\link[memoise]{memoise}} to make repeated calls faster.
}
\examples{
 n_tips <- 6
 AllQuartets(n_tips)
 
 combn(n_tips, 4) # Provides the same information, but for large 
                  # values of n_tips is significantly slower.

}
\seealso{
\code{\link[utils]{combn}}

Other quartet counting functions: \code{\link{ResolvedQuartets}}
}
\author{
Martin R. Smith
}
\concept{quartet counting functions}
