% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_tools.R
\name{Precision_Recall}
\alias{Precision_Recall}
\title{Precision}
\usage{
Precision_Recall(hx, Truth)
}
\arguments{
\item{hx}{a numeric vector of cluster selection}

\item{Truth}{the ground truth for clusters}
}
\value{
\describe{
 \item{TP}{ The number of true positive links}
 \item{TN}{ The number of true negative links}
 \item{FP}{ The number of false positive links}
 \item{FN}{ The number of false negative links}
 \item{Pr}{ The precision, defined by \eqn{Pr = \frac{TP}{TP+FP}}}
 \item{R}{The recall, defined by \eqn{R = \frac{TP}{TP+FN}}}
 \item{F1}{The F1 index, defined by \eqn{F1 = \frac{2\times P \times R}{P + R}}}
 \item{RI}{Rand Index, defined by \eqn{RI = \frac{TP+TN}{TP+TN+FP+FN}}}
 \item{validat}{Is positives + negatives equal to total number of links - returns absolute difference if false }
 }
}
\description{
Computes the precision based on the clustering
}
\examples{
set.seed(123)
#1: Cluster data
FQC<-FlashQC(QuantumClone::Input_Example,conta = c(0,0),Nclus = 2:10)

#2: Compute NMI
Precision_Recall(hx = FQC$cluster,Truth = QuantumClone::Input_Example[[1]]$Chr)

### From Stanford NLP example:
cluster<-c(rep(1,6),rep(2,6),rep(3,5))
truth<-c(rep(1,5),2,
         1,rep(2,4),3,
         rep(1,2),rep(3,3))
Precision_Recall(cluster,truth)
}
