% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descent.R
\name{grbase}
\alias{grbase}
\title{Computes gradient of function}
\usage{
grbase(fik, adj.factor, centers, Alt, Depth)
}
\arguments{
\item{fik}{Evaluation of fik for previous iteration}

\item{adj.factor}{Factor to compute the probability: makes transition between the cellularity of the clone and the frequency observed}

\item{centers}{vector with cellularity of each clone (numeric vector, ordered by samples)}

\item{Alt}{Matrix with number of draws in rows for a mutation/possibility, and samples in columns}

\item{Depth}{Matrix with number of not draws (Depth - Alt) in rows for a mutation/possibility, and samples in columns}
}
\description{
Computes gradient of function
}
\examples{
fik<-matrix(c(1,0,0,1),nrow = 2)
adj.factor<-matrix(1/2,nrow =2 ,ncol =1)
centers<-c(0.25,0.75)
Alt<-c(125,375)
Depth<-c(1000,1000)
grbase(fik,adj.factor,centers,Alt,Depth)
}

