% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentileSeek.R
\name{updateGamma}
\alias{updateGamma}
\title{Update Gamma (percentile value).}
\usage{
updateGamma(scores, z, desired.props, gamma.perc, index.to.update,
  restaurant.tol = 10, iter = 1, max.iterations = 20, gamma_upper = NA,
  gamma_lower = NA, resolve.ties = FALSE)
}
\arguments{
\item{scores}{Numeric vector of size \code{n}, where \code{n} is the number is restaurants
to be graded. \code{scores[i]} represents the mean or raw
inspection score for restaurant \code{i}.}

\item{z}{Character vector representing ZIP codes. \code{z[i]} is the ZIP code for
restaurant \code{i}.}

\item{desired.props}{Numeric vector representing desired global grade
proportions across the entire jurisdiction. \code{desired.props[j]} is the desired
proportion of total (gradeable) restaurants in the \code{j}th highest
grading category.}

\item{gamma.perc}{Numeric vector representing an initial set of percentiles.}

\item{index.to.update}{Integer value in the set
\code{1:(length(desired.props)-1)} that represents the particular
percentile to be updated in the current run of \code{updateGamma}.
(Percentiles are not updated simultaneously, but rather are updated
sequentially with the smallest percentiles being the first to be updated.)}

\item{restaurant.tol}{Integer value representing the maximum difference in
number of restaurants suggested by \code{desired.props} and the actual
number of restaurants in each of the top \code{(length(desired.props) -
1)} grade categories.}

\item{iter}{Integer value representing the current iteration of \code{updateGamma}.}

\item{max.iterations}{Integer value specifying the maximum number of
calls of the \code{\link{updateGamma}} percentile update function
for each of the sought after percentiles.}

\item{gamma_upper}{Numeric or NA value representing a value of
\code{gamma.perc[index.to.update]} that results in too many restaurants
gaining the desired grade proportion.}

\item{gamma_lower}{Numeric or NA value representing a value of
\code{gamma.perc[index.to.update]} that results in too few restaurants
gaining the desired grade proportion.}

\item{resolve.ties}{Boolean value specifying interpretation of how the
function's returned percentile will be applied across the subunits see:
\link{percentileSeek}. Should \emph{as close to} (desired.props[1])\% of
restaurants in a ZIP code receive an "A" grade, and \emph{as close to}
(desired.props[2])\% of restaurants in a ZIP code receive "B" grades
(\code{resolve.ties = TRUE} case)? Or should the returned percentiles be
interpretted as R \link[stats]{quantile} \code{Type = 1} percentiles, and
\emph{at least} (desired.props[1])\% of restaurants in a ZIP code receive
an "A" grade?}
}
\value{
A numeric value representing a percentile to be applied to each ZIP code
 so as to achieve a particular desired proportion of grades.
}
\description{
\code{updateGamma} is the percentile update function called by
\code{\link{percentileSeek}} as \code{\link{percentileSeek}} attempts to
match a set of grade proportions to a set of \code{desired.props}.
}
\details{
\code{updateGamma} performs the update of
\code{gamma.perc[index.to.update]}. In particular, \code{gamma.perc[index.to.update]} will
be updated until either the number of updates has reached
\code{max.iterations}, or the difference between the proportion of
(gradeable) restaurants scoring the \code{(index.to.update)}th highest grade
is within \code{(restaurant.tol/ no.gradeable.rests)} of the desired
proportion, where \code{no.gradeable.rests} is the number of gradeable
restaurants (restaurants that have both ZIP code and inspection score
information).  Initially, \code{gamma.perc[index.to.update]} is updated
according to the rule \code{gamma.perc[index.to.update] <-
(gamma.perc[index.to.update] - diff.aj.desired)}, where \code{diff.aj.desired}
is the difference between the actual proportion of restaurants assigned the grade
of interest and the desired proportion. However, if the algorithm locates
values of \code{gamma.perc[index.to.update]} that produce grade proportions
that are both higher and lower than the desired proportion,
\code{gamma_upper} and \code{gamma_lower} respectively, the update rule
becomes \code{gamma.perc[index.to.update]<- 0.5*(gamma_upper +
gamma_lower)}, as in the bisection root finding method.
}
\keyword{internal}

