% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_ext.R
\name{quantile_vcov}
\alias{quantile_vcov}
\title{Variance-Covariance of Quantiles}
\usage{
quantile_vcov(p, d)
}
\arguments{
\item{p}{\link[base]{numeric} \link[base]{vector},
cumulative probabilities at the given quantiles}

\item{d}{\link[base]{numeric} \link[base]{vector},
probability densities at the given quantiles}
}
\value{
Function \link{quantile_vcov} returns the variance-covariance \link[base]{matrix} of quantiles.
}
\description{
To compute the variance-covariance matrix of quantiles
based on Theorem 1 and 2 of Mosteller (1946).
}
\details{
The end user should make sure no density too close to 0 is included in argument \code{d}.

Function \link{quantile_vcov} must not be used in a compute-intensive way.
}
\references{
Frederick Mosteller. On Some Useful "Inefficient" Statistics (1946).
\doi{10.1214/aoms/1177730881}
}
\keyword{internal}
