% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment_vanilla.R
\docType{class}
\name{moment_}
\alias{moment_}
\alias{moment-class}
\alias{moment_GH}
\alias{moment_sn}
\alias{moment_st}
\alias{moment_norm}
\alias{moment_.character}
\alias{moment_.fmx}
\title{Raw, Central and Standardized Moments, and other Distribution Characteristics}
\usage{
moment_GH(A, B, g, h)

moment_sn(xi, omega, alpha)

moment_st(xi, omega, alpha, nu)

moment_norm(mean, sd)

moment_(dist, ...)

\method{moment_}{character}(dist = c("norm", "GH", "sn", "st"), ...)

\method{moment_}{fmx}(dist, ...)
}
\arguments{
\item{A, B, g, h}{\link[base]{numeric} \link[base]{vector}s or scalars,
parameters of Tukey's \eqn{gh} distribution \code{\link[=dGH]{dGH()}}}

\item{xi, omega, alpha}{\link[base]{numeric} \link[base]{vector}s or scalars,
location, scale and slant parameters for skew-normal \link[sn]{dsn} and
skew-\eqn{t} \link[sn]{dst} distributions}

\item{nu}{positive \link[base]{numeric} \link[base]{vector} or scalar,
degrees of freedom(s) of skew-\eqn{t} \link[sn]{dst} distribution}

\item{mean, sd}{\link[base]{numeric} \link[base]{vector}s or scalars, mean and standard deviation
parameters for normal \link[stats]{dnorm} distribution}

\item{dist}{see \strong{Usage}}

\item{...}{distribution parameters as described in \strong{Arguments} for \code{\link[=moment_.character]{moment_.character()}},
or place holder for S3 method dispatch for \code{\link[=moment_.fmx]{moment_.fmx()}}}
}
\value{
Functions \code{\link[=moment_]{moment_()}}, \code{\link[=moment_GH]{moment_GH()}}, \code{\link[=moment_sn]{moment_sn()}}, \code{\link[=moment_st]{moment_st()}}, \code{\link[=moment_norm]{moment_norm()}} all return a \linkS4class{moment} object.
}
\description{
Up to 4th order of raw \eqn{E(Y^n)}, central \eqn{E[(Y-\mu)^n]} and
standardized moments \eqn{E[(Y-\mu)^n]/\sigma^n} of the random variable
\eqn{Y = (X - \mathtt{location})/\mathtt{scale}},
as well as the distribution characteristics
(e.g., mean, standard deviation, skewness and excess kurtosis) of the random variable \eqn{X}.
}
\details{
For \eqn{Y = (X - \mathtt{location})/\mathtt{scale}},
let \eqn{\mu = E(Y)}, then the second to fourth central moments of \eqn{Y} are,
\deqn{E[(Y-\mu)^2] = E(Y^2) - 2\mu E(Y) + \mu^2 = E(Y^2) - \mu^2}
\deqn{E[(Y-\mu)^3] = E(Y^3) - 3\mu E(Y^2) + 3\mu^2 E(Y) - \mu^3 = E(Y^3) - 3\mu E(Y^2) + 2\mu^3}
\deqn{E[(Y-\mu)^4] = E(Y^4) - 4\mu E(Y^3) + 6\mu^2 E(Y^2) - 4\mu^3 E(Y) + \mu^4 = E(Y^4) - 4\mu E(Y^3) + 6\mu^2 E(Y^2) - 3\mu^4}

The distribution characteristics of \eqn{Y} are,
\deqn{\mu_Y = \mu}
\deqn{\sigma_Y = \sqrt{E[(Y-\mu)^2]}}
\deqn{\mathtt{skewness}_Y = E[(Y-\mu)^3] / \sigma^3_Y}
\deqn{\mathtt{kurtosis}_Y = E[(Y-\mu)^4] / \sigma^4_Y - 3}

The distribution characteristics of \eqn{X} are
\eqn{\mu_X = \mathtt{location} + \mathtt{scale}\cdot \mu_Y},
\eqn{\sigma_X = \mathtt{scale}\cdot \sigma_Y},
\eqn{\mathtt{skewness}_X = \mathtt{skewness}_Y}, and
\eqn{\mathtt{kurtosis}_X = \mathtt{kurtosis}_Y}.

The S3 method dispatch \code{\link[=moment_.character]{moment_.character()}} obtains the moments and distribution characteristics from
the distribution name \code{dist} and parameters given in \code{...}.

The S3 method dispatch \code{\link[=moment_.fmx]{moment_.fmx()}} obtains the moments and distribution characteristics of each mixture component of
an \linkS4class{fmx} object.
}
\section{Slots}{

\describe{
\item{\code{distname}}{\link[base]{character} scalar, name of distribution,
e.g., \code{'norm'} for normal, \code{'sn'} for skew-normal, \code{'st'} for skew-\eqn{t},
and \code{GH} for Tukey's \eqn{g}-and-\eqn{h} distribution,
following the nomenclature of \link[stats]{dnorm}, \link[sn]{dsn}, \link[sn]{dst} and \code{\link[=dGH]{dGH()}}}

\item{\code{location,scale}}{\link[base]{numeric} \link[base]{vector}s or scalars,
location and scale parameters}

\item{\code{mu}}{\link[base]{numeric} \link[base]{vector} or scalar,
1st order \emph{raw} moment \eqn{\mu = E(Y)}.
Note that the 1st order central moment \eqn{E(Y-\mu)} and
standardized moment \eqn{E(Y-\mu)/\sigma} are 0.}

\item{\code{raw2,raw3,raw4}}{\link[base]{numeric} \link[base]{vector}s or scalars,
2nd or higher order \emph{raw} moments \eqn{E(Y^n)}, \eqn{n\geq 2}}

\item{\code{central2,central3,central4}}{\link[base]{numeric} \link[base]{vector}s or scalars,
2nd or higher order \emph{central} moments, \eqn{\sigma^2 = E[(Y-\mu)^2]} and
\eqn{E[(Y-\mu)^n]}, \eqn{n\geq 3}}

\item{\code{standardized3,standardized4}}{\link[base]{numeric} \link[base]{vector}s or scalars,
3rd or higher order \emph{standardized} moments,
skewness \eqn{E[(Y-\mu)^3]/\sigma^3} and
kurtosis \eqn{E[(Y-\mu)^4]/\sigma^4}.
Note that the 2nd standardized moment is 1}

\item{\code{mean,sd,skewness,kurtosis}}{\link[base]{numeric} \link[base]{vector}s or scalars,
distribution characteristics of random variable \eqn{X}, such as mean, standard deviation, skewness, and excess kurtosis}
}}

\note{
Potential name clash with \code{e1071::moment}.
}
\examples{
library(ggplot2)

moment_(dist = 'norm', mean = 1.234, sd = .58)

\dontrun{ # requires Tingting's \pkg{QuantileGH}
A = 3; B = 1.5; g = .7; h = .1
moment_(dist = 'GH', A = A, B = B, g = 0, h = h)
moment_(dist = 'GH', A = A, B = B, g = g, h = 0)
moment_(dist = 'GH', A = A, B = B, g = g, h = h)}

xi = 2; omega = 1.3; alpha = 3; nu = 6

ggplot() + geom_function(fun = sn::dsn, args = list(
  xi = xi, omega = omega, alpha = alpha
), xlim = c(0, 6))
moment_(dist = 'sn', xi, omega, alpha)

ggplot() + geom_function(fun = sn::dst, args = list(
  xi = xi, omega = omega, alpha = alpha, nu = nu
), xlim = c(0, 6))
moment_(dist = 'st', xi, omega, alpha, nu)


}
\references{
\url{https://en.wikipedia.org/wiki/Binomial_theorem}
\url{https://en.wikipedia.org/wiki/Central_moment}
\url{https://en.wikipedia.org/wiki/Standardized_moment}
\url{https://en.wikipedia.org/wiki/Skewness}
\url{https://en.wikipedia.org/wiki/Kurtosis}

Raw moments of Tukey's GH: \doi{10.1002/9781118150702.ch11}

Raw moments of skew-normal: \url{https://en.wikipedia.org/wiki/Skew_normal_distribution}

Raw moments of skew-\eqn{t}: \url{https://arxiv.org/abs/0911.2342}

Raw moments of normal: \url{https://en.wikipedia.org/wiki/Normal_distribution} (replace with \eqn{\mu = 0} and \eqn{\sigma = 1})
}
