% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmxS.R
\docType{class}
\name{fmxS}
\alias{fmxS}
\alias{fmxS-class}
\title{\linkS4class{fmxS}: Multiple \linkS4class{fmx} objects}
\usage{
fmxS(...)
}
\arguments{
\item{...}{multiple \linkS4class{fmx} objects, or objects convertible
to \linkS4class{fmx} class via function \code{\link[=as.fmx]{as.fmx()}}}
}
\value{
Function \code{\link[=fmxS]{fmxS()}} returns an \linkS4class{fmxS} object.
}
\description{
..
}
\section{Slots}{

\describe{
\item{\code{.Data}}{\link[base]{list} of \linkS4class{fmx} objects}

\item{\code{data}}{\link[base]{numeric} \link[base]{vector}}

\item{\code{data.name}}{\link[base]{character} scalar}
}}

\examples{

library(fitdistrplus)
set.seed(1234); x = rnorm(n = 1e3L)
f1 = fitdist(x, distr = 'norm')
f2 = fitdist(x, distr = 'GH', start = as.list.default(letterValue(x)))
aa = fmxS(a = f1, b = f2)
summary(aa)
autoplot(aa, type = 'density')
autoplot(aa, type = 'distribution')

a1 = fmx('GH', A = c(7,9), B = c(.8, 1.2), g = c(.3, 0), h = c(0, .1), w = c(1, 1))
a2 = fmx('GH', A = c(6,9), B = c(.8, 1.2), g = c(-.3, 0), h = c(.2, .1), w = c(4, 6))
a = fmxS(a1, a2)
(p = autoplot(a, type = 'distribution') + coord_flip())
p + labs(x = 'new xlab', y = 'new ylab')
p + theme(legend.position = 'none')

}
